package net.dark.spv_addon.entities.custom;

import com.sp.entity.ik.components.IKAnimatable;
import com.sp.entity.ik.components.IKModelComponent;
import com.sp.entity.ik.model.ModelAccessor;
import com.sp.entity.ik.parts.Segment;
import com.sp.entity.ik.parts.ik_chains.TargetReachingIKChain;
import com.sp.entity.ik.parts.sever_limbs.ServerLimb;
import net.dark.spv_addon.entities.ai.SlightlyBetterMobNavigation;
import net.dark.spv_addon.entities.ai.goals.AggroNearestPlayerGoal;
import net.dark.spv_addon.entities.ai.goals.BellWalkerStalkGoal;
import net.dark.spv_addon.entities.ik.components.IKLegCompDark;
import net.dark.spv_addon.init.ModSounds;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class BellWalkerEntity extends class_1314
        implements IKAnimatable<BellWalkerEntity>, GeoAnimatable {

    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    private final IKLegCompDark<TargetReachingIKChain, BellWalkerEntity> legComponent;

    private class_1657 stalkTarget = null;
    private int stalkCooldown = 0;
    private class_243 lastHeardPos = null;

    public BellWalkerEntity(class_1299<? extends BellWalkerEntity> type, class_1937 world) {
        super(type, world);
        this.field_6189 = new SlightlyBetterMobNavigation(this, world);

        List<ServerLimb> endpoints = List.of(
                new ServerLimb(1.25, 0.0, 1.25),
                new ServerLimb(-1.25, 0.0, 1.25),
                new ServerLimb(1.25, 0.0, 0.1),
                new ServerLimb(-1.25, 0.0, 0.1),
                new ServerLimb(1.25, 0.0, -1.25),
                new ServerLimb(-1.25, 0.0, -1.25)
        );
        IKLegCompDark.LegSetting setting = new IKLegCompDark.LegSetting.Builder()
                .maxDistance(0.5)
                .stepInFront(1)
                .movementSpeed(0.7)
                .maxStandingStillDistance(0.2)
                .standStillCounter(20)
                .build();
        List<IKLegCompDark.LegSetting> settings = endpoints.stream()
                .map(e -> setting).collect(Collectors.toList());
        TargetReachingIKChain chain = new TargetReachingIKChain(
                new Segment.Builder().length(0.20).build(),
                new Segment.Builder().length(0.60).build(),
                new Segment.Builder().length(0.80).build(),
                new Segment.Builder().length(0.40).build()
        );
        this.legComponent = new IKLegCompDark<>(
                settings, endpoints,
                chain, chain, chain,
                chain, chain, chain
        );
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 3000.0)
                .method_26868(class_5134.field_23719, 0.5)
                .method_26868(class_5134.field_23721, 7.5)
                .method_26868(class_5134.field_23718, 1000.0);
    }

    @Override
    public boolean method_5643(net.minecraft.class_1282 source, float amount) {
        return false;
    }

    @Override
    public boolean method_5679(net.minecraft.class_1282 damageSource) {
        return true;
    }

    public void clearStalkTarget() {
        this.stalkTarget = null;
        this.stalkCooldown = 0;
        this.lastHeardPos = null;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, new class_1366(this, 0.75, true));
        this.field_6201.method_6277(1, new class_1376(this));
        this.field_6201.method_6277(2, new SmartWanderGoal(this, 0.5, 10, 60));
        this.field_6201.method_6277(1, new AggroNearestPlayerGoal(this, 20.0));
        this.field_6201.method_6277(1, new BellWalkerStalkGoal(this, 0.75, 0.30));
    }

    public void onPlayerSoundHeard(class_1657 player, class_243 pos) {
        this.stalkTarget = player;
        this.lastHeardPos = pos;
        this.stalkCooldown = 100;
    }

    public boolean hasStalkTarget() {
        return stalkTarget != null && stalkCooldown > 0 && stalkTarget.method_5805() && stalkTarget.method_5739(this) < 32;
    }

    public class_1657 getStalkTarget() {
        return hasStalkTarget() ? stalkTarget : null;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        legComponent.tickServer(this);

        if (stalkCooldown > 0) {
            stalkCooldown--;
            if (stalkCooldown == 0) stalkTarget = null;
        }
        if (!hasStalkTarget() && field_6012 % 40 == 0 && this.method_37908().field_9229.method_43048(8) == 0) {
            this.method_5783(ModSounds.BELLWALKER_BELL, 1.0f, 1.0f);
        }
        if (!this.method_37908().field_9236) {
            double detectRadius = 18.0;
            for (class_1657 player : this.method_37908().method_18456()) {
                if (net.dark.spv_addon.voicechat.SpvAddonVoicechatPlugin.justMadeNoise.contains(player.method_5667())
                        && player.method_5858(this) < detectRadius * detectRadius
                        && !player.method_7325() && player.method_5805()) {
                    this.onPlayerSoundHeard(player, player.method_19538());
                }
            }
        }
        if (hasStalkTarget()) {
            this.method_5980(this.stalkTarget);
        }
    }

    @Override
    public List<IKModelComponent<BellWalkerEntity>> getComponents() {
        return List.of(legComponent);
    }

    @Override
    public double getSize() {
        return 1.0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }

    @Override
    public double getTick(Object o) {
        return 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void applyModelPose(ModelAccessor model) {
        legComponent.getModelPositions(this, model);
        legComponent.tickClient(this, model);
    }

    public static class SmartWanderGoal extends class_1352 {
        private final class_1314 mob;
        private final double speed;
        private final int minIdle, maxIdle;
        private int idleTicks;
        private boolean idlePhase = true;

        public SmartWanderGoal(class_1314 mob, double speed, int minIdle, int maxIdle) {
            this.mob = mob;
            this.speed = speed;
            this.minIdle = minIdle;
            this.maxIdle = maxIdle;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            resetIdle();
        }

        private void resetIdle() {
            int range = maxIdle - minIdle;
            idleTicks = minIdle + mob.method_6051().method_43048(range + 1);
        }

        @Override
        public boolean method_6264() {
            return mob.method_5942().method_6357();
        }

        @Override
        public boolean method_6266() {
            return true;
        }

        @Override
        public void method_6268() {
            if (idlePhase) {
                if (--idleTicks <= 0) {
                    double dx = (mob.method_6051().method_43058() * 2 - 1) * 10;
                    double dz = (mob.method_6051().method_43058() * 2 - 1) * 10;
                    class_2338 dest = mob.method_24515().method_10069((int) dx, 0, (int) dz);
                    mob.method_5942().method_6337(
                            dest.method_10263(), dest.method_10264(), dest.method_10260(), speed
                    );
                    idlePhase = false;
                }
            } else {
                if (mob.method_5942().method_6357()) {
                    mob.method_5783(ModSounds.BELLWALKER_BELL, 0.5f, 0.5f);
                    idlePhase = true;
                    resetIdle();
                }
            }
        }
    }
}