package net.dark.spv_addon.entities.custom;

import com.sp.entity.ik.components.IKAnimatable;
import com.sp.entity.ik.parts.Segment;
import com.sp.entity.ik.parts.ik_chains.TargetReachingIKChain;
import com.sp.entity.ik.parts.sever_limbs.ServerLimb;
import net.dark.spv_addon.entities.ik.components.IKArmComp;
import net.dark.spv_addon.entities.ik.components.IKLegCompIkeaWalker;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1937;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.List;
import java.util.stream.Collectors;

public class IkeaWalkerEntity extends class_1314
        implements IKAnimatable<IkeaWalkerEntity>, GeoAnimatable {

    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    private final IKLegCompIkeaWalker<TargetReachingIKChain, IkeaWalkerEntity> legComponent;
    private final IKArmComp<TargetReachingIKChain, IkeaWalkerEntity> armComponent;

    public IkeaWalkerEntity(class_1299<? extends IkeaWalkerEntity> type, class_1937 world) {
        super(type, world);

        // Jambes
        List<ServerLimb> legEndpoints = List.of(
                new ServerLimb(0.12, 0.0, 0.1),
                new ServerLimb(-0.12, 0.0, 0.1)
        );
        IKLegCompIkeaWalker.LegSetting legSetting = new IKLegCompIkeaWalker.LegSetting.Builder()
                .maxDistance(0.5)
                .stepInFront(0.3)
                .movementSpeed(0.15)
                .maxStandingStillDistance(0.05)
                .standStillCounter(12)
                .build();
        List<IKLegCompIkeaWalker.LegSetting> legSettings = legEndpoints.stream()
                .map(e -> legSetting).collect(Collectors.toList());

        TargetReachingIKChain leftLeg = new TargetReachingIKChain(
                new Segment.Builder().length(0.4).build(),
                new Segment.Builder().length(0.4).build()
        );
        TargetReachingIKChain rightLeg = new TargetReachingIKChain(
                new Segment.Builder().length(0.4).build(),
                new Segment.Builder().length(0.4).build()
        );

        this.legComponent = new IKLegCompIkeaWalker<>(
                legSettings, legEndpoints,
                leftLeg, rightLeg
        );

        // Bras
        List<ServerLimb> armEndpoints = List.of(
                new ServerLimb(0.2, 1.5, -0.1),
                new ServerLimb(-0.2, 1.5, -0.1)
        );
        IKArmComp.LegSetting armSetting = new IKArmComp.LegSetting.Builder()
                .maxDistance(0.5)
                .stepInFront(0.2)
                .movementSpeed(0.25)
                .maxStandingStillDistance(0.04)
                .standStillCounter(12)
                .build();
        List<IKArmComp.LegSetting> armSettings = armEndpoints.stream()
                .map(e -> armSetting).collect(Collectors.toList());

        TargetReachingIKChain leftArm = new TargetReachingIKChain(
                new Segment.Builder().length(0.05).build(),
                new Segment.Builder().length(0.45).build(),
                new Segment.Builder().length(0.35).build()

        );
        TargetReachingIKChain rightArm = new TargetReachingIKChain(
                new Segment.Builder().length(0.05).build(),
                new Segment.Builder().length(0.45).build(),
                new Segment.Builder().length(0.35).build()
        );

        this.armComponent = new IKArmComp<>(
                armSettings, armEndpoints,
                leftArm, rightArm
        );
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 400.0)
                .method_26868(class_5134.field_23719, 0.5)
                .method_26868(class_5134.field_23721, 6.0)
                .method_26868(class_5134.field_23717, 50.0);
    }

    @Override
    protected void method_5959() {
        if (this.method_37908().method_8530()) {
            this.field_6201.method_6277(0, new class_1376(this));
        } else {
            this.field_6201.method_6277(0, new class_1366(this, 1.0, true));
            this.field_6185.method_6277(1, new net.minecraft.class_1400<>(this, net.minecraft.class_1309.class, true));
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        legComponent.tickServer(this);
        armComponent.tickServer(this);

        // Attirer vers le joueur tenant un os
        this.method_37908().method_18456().stream()
                .filter(player -> player.method_6047().method_7909().toString().toLowerCase().contains("bone"))
                .findFirst()
                .ifPresent(player -> {
                    double dx = player.method_23317() - this.method_23317();
                    double dz = player.method_23321() - this.method_23321();
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    if (distance > 2.0) { // Garde une petite distance
                        double speed = 0.5;
                        this.method_5942().method_6335(player, speed);
                    }
                });
    }

    @Override
    public List<com.sp.entity.ik.components.IKModelComponent<IkeaWalkerEntity>> getComponents() {
        return List.of(legComponent, armComponent);
    }

    @Override
    public double getSize() {
        return 2;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }

    @Override
    public double getTick(Object o) {
        return 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {

    }
}