package net.dark.spv_addon.entities.custom;

import com.sp.cca_stuff.InitializeComponents;
import com.sp.init.BackroomsLevels;
import com.sp.world.levels.BackroomsLevel;
import net.dark.spv_addon.init.ModBlocks;
import net.dark.spv_addon.world.levels.custom.LevelKittyBackroomsLevel;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KittyEntity extends class_1314 implements GeoAnimatable {

    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    public float headYaw = 0.0F;
    public float headPitch = 0.0F;

    private int followTicks = 0;
    private boolean isAggressive = false;
    private class_1657 targetPlayer = null;
    private static final int AGGRO_TICKS = 3600;

    public KittyEntity(class_1299<? extends KittyEntity> type, class_1937 world) {
        super(type, world);
        if (!world.field_9236 && world.method_27983() == net.dark.spv_addon.init.BackroomsLevels.LEVEL_KITTY_WORLD_KEY) {
            this.method_5808(15.0, 2.0, 15.0, this.method_36454(), this.method_36455());
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 40000.0)
                .method_26868(class_5134.field_23719, 0)
                .method_26868(class_5134.field_23721, 2.0);
    }

    public double getSize() {
        return 2.8;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1366(this, 1.0, true) {
            @Override
            public boolean method_6264() {
                return isAggressive && targetPlayer != null && KittyEntity.this.method_5858(targetPlayer) < 4.0D;
            }

            @Override
            public void method_6269() {
                KittyEntity.this.method_5980(targetPlayer);
                super.method_6269();
            }
        });
        this.field_6201.method_6277(1, new class_1376(this));
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (!this.method_37908().field_9236) {
            double range = 64.0;
            class_1657 nearest = null;
            double nearestDist = Double.MAX_VALUE;
            boolean isSeen = false;

            for (class_1657 player : this.method_37908().method_18456()) {
                double dist = this.method_5858(player);
                if (dist <= range * range) {
                    if (player.method_6057(this)) {
                        isSeen = true;
                        break;
                    }
                    if (dist < nearestDist) {
                        nearest = player;
                        nearestDist = dist;
                    }
                }
            }

            if (!isSeen && nearest != null) {
                double px = nearest.method_23317() + (this.field_5974.method_43058() - 0.5) * 2.5;
                double py = nearest.method_23318();
                double pz = nearest.method_23321() + (this.field_5974.method_43058() - 0.5) * 2.5;
                this.method_5859(px, py, pz);
                this.method_36456(nearest.method_36454());
                this.method_5847(nearest.method_36454());
                this.method_5636(nearest.method_36454());
                this.field_6241 = nearest.method_36454();
            }
        }

        class_1657 closest = null;
        double minDist = Double.MAX_VALUE;
        for (class_1657 player : this.method_37908().method_18456()) {
            double dist = this.method_5858(player);
            if (dist < minDist) {
                closest = player;
                minDist = dist;
            }
        }

        if (closest != null && minDist < 16 * 16) {
            if (targetPlayer == closest) {
                followTicks++;
            } else {
                targetPlayer = closest;
                followTicks = 0;
                isAggressive = false;
            }
            if (followTicks > AGGRO_TICKS) {
                isAggressive = true;
            }
        } else {
            followTicks = 0;
            isAggressive = false;
            targetPlayer = null;
        }

        if (closest != null) {
            double dx = closest.method_23317() - this.method_23317();
            double dy = closest.method_23320() - this.method_23320();
            double dz = closest.method_23321() - this.method_23321();
            double dist = Math.sqrt(dx * dx + dz * dz);
            float targetYaw = (float) (Math.toDegrees(Math.atan2(dx, dz)));
            float targetPitch = (float) (Math.atan2(dy, dist) * (180F / Math.PI));
            this.field_6241 += class_3532.method_15393(targetYaw - this.field_6241) * 0.2F;
            this.headPitch += (targetPitch - this.headPitch) * 0.2F;
            this.field_6241 += class_3532.method_15393(targetYaw + this.field_6241) * 0.2F;
            this.headPitch += (targetPitch + this.headPitch) * 0.2F;
        }
    }


    @Override
    public float method_5791() {
        return this.field_6241;
    }

    @Override
    public float method_5695(float tickDelta) {
        return this.headPitch;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }

    @Override
    public double getTick(Object o) {
        return field_6012;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);

            if (!stack.method_31574(ModBlocks.KITTY_PLUSHIE1.method_8389())) {
                return super.method_5992(player, hand);
            }

            if (!player.method_37908().field_9236 && player instanceof class_3222 serverPlayer) {
                if (serverPlayer.method_37908().method_27983() == net.dark.spv_addon.init.BackroomsLevels.LEVEL_KITTY_WORLD_KEY) {
                    var level = (LevelKittyBackroomsLevel) net.dark.spv_addon.init.BackroomsLevels.LEVEL_KITTY_BACKROOMS_LEVEL;
                    var pc = InitializeComponents.PLAYER.get(serverPlayer);
                    var tp = new BackroomsLevel.CrossDimensionTeleport(
                            serverPlayer.method_37908(),
                            pc,
                            level.getSpawnPos(),
                            net.dark.spv_addon.init.BackroomsLevels.LEVEL_KITTY_BACKROOMS_LEVEL,
                            BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL
                    );

                    if (level.transitionOut(tp)) {
                                serverPlayer.method_14251(
                                        serverPlayer.method_5682().method_3847(BackroomsLevels.POOLROOMS_WORLD_KEY),
                                        15, 90, 15,
                                        serverPlayer.method_36454(), -90);

                        return class_1269.method_29236(true);
                    }
                }
            }

            return super.method_5992(player, hand);
        }
    }