package net.dark.spv_addon.entities.ik.components;

import com.sp.entity.ik.components.IKAnimatable;
import com.sp.entity.ik.model.BoneAccessor;
import com.sp.entity.ik.model.ModelAccessor;
import com.sp.entity.ik.parts.ik_chains.IKChain;
import com.sp.entity.ik.parts.sever_limbs.ServerLimb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class IKArmComp<C extends IKChain, E extends IKAnimatable<E>>
        extends com.sp.entity.ik.components.IKLegComponent<C, E> {

    private final List<ServerLimb> endPoints;
    private final List<class_243> bases;
    private final List<LegSetting> settings;
    private final List<Double> stepProgress = new ArrayList<>();
    private int stillStandCounter = 0;

    @SafeVarargs
    public IKArmComp(List<LegSetting> settings, List<ServerLimb> endpoints, C... limbs) {
        super(settings, endpoints, limbs);
        this.endPoints = endpoints;
        this.bases = new ArrayList<>();
        this.settings = settings;
        Arrays.stream(limbs).forEach(limb -> this.bases.add(class_243.field_1353));
        for (int i = 0; i < endpoints.size(); i++) stepProgress.add(0.0);
    }

    private static boolean hasMovedOverLastTick(class_1314 entity) {
        class_243 vel = entity.method_18798();
        float yawDelta = Math.abs(entity.method_5791() - entity.field_6259);
        return vel.field_1352 != 0 || vel.field_1350 != 0 || yawDelta >= 0.01F;
    }

    public static class_3965 rayCastToGround(class_243 limbBase, class_1297 entity, class_3959.class_242 fluid) {
        class_1937 world = entity.method_37908();
        return world.method_17742(
                new class_3959(
                        limbBase.method_43206(class_2350.field_11036, 2.5),
                        limbBase.method_43206(class_2350.field_11033, 8),
                        class_3959.class_3960.field_17558,
                        fluid,
                        entity
                )
        );
    }

    private class_243 adjustForWall(class_1314 entity, class_243 from, class_243 to) {
        class_1937 world = entity.method_37908();
        class_243 dir = to.method_1020(from);
        double dist = dir.method_1033();
        if (dist < 0.01) return to;
        dir = dir.method_1029();
        class_243 checkTo = from.method_1019(dir.method_1021(dist + 0.15));
        class_3965 hit = world.method_17742(new class_3959(
                from, checkTo,
                class_3959.class_3960.field_17558,
                class_3959.class_242.field_1348,
                entity
        ));
        if (hit.method_17783() == class_3965.Type.field_1332) {
            return hit.method_17784().method_1020(dir.method_1021(0.08));
        }
        return to;
    }

    @Override
    public void tickClient(E animatable, ModelAccessor model) {
        class_1297 entity = (class_1297) animatable;
        long age = entity.field_6012;
        boolean isWalking = entity.method_24828() && entity.method_18798().method_37268() > 0.01;

        for (int i = 0; i < this.limbs.size(); i++) {
            var optBone = model.getBone("base_arm" + (i + 1));
            if (optBone.isEmpty()) return;
            class_243 basePos = this.bases.get(i);
            C limbChain = this.setLimb(i, basePos, entity);

            double breathing = Math.sin((age + i * 12) * 0.035) * 0.05;

            // Swing et vertical offset pour la marche
            double swingPhase = (i == 0 ? 0 : Math.PI);
            double swing = 0.0;
            double vertical = 0.0;
            if (isWalking) {
                double walkCycle = age * 0.18;
                swing = Math.sin(walkCycle + swingPhase) * 0.18;
                vertical = Math.abs(Math.cos(walkCycle + swingPhase)) * 0.10;
            }

            double progress = stepProgress.get(i);
            double handArc = 0.0;
            if (progress < 1.0) {
                double t = 0.5 - 0.5 * Math.cos(Math.PI * progress);
                handArc = Math.sin(Math.PI * t) * 0.22 + breathing;
            } else {
                handArc = breathing;
            }

            List<class_243> joints = limbChain.getJoints();
            List<class_243> interpolatedJoints = new ArrayList<>();
            double interpFactor = 0.25;

            for (int k = 0; k < joints.size(); k++) {
                class_243 current = joints.get(k);
                class_243 target = current;
                if (k > 0) {
                    class_243 prev = interpolatedJoints.get(k - 1);
                    class_243 dir = current.method_1020(prev).method_1029();
                    double maxAngle = Math.toRadians(80);
                    class_243 baseDir = new class_243(0, -1, 0);
                    double angle = Math.acos(dir.method_1026(baseDir));
                    if (angle > maxAngle) {
                        dir = baseDir.method_1019(dir.method_1020(baseDir).method_1029().method_1021(Math.tan(maxAngle)));
                        target = prev.method_1019(dir.method_1021(current.method_1020(prev).method_1033()));
                    }
                }
                if (k < joints.size() - 1) {
                    class_243 next = joints.get(k + 1);
                    target = target.method_35590(next, interpFactor);
                }
                interpolatedJoints.add(target);
            }

            for (int k = 0; k < interpolatedJoints.size() - 1; k++) {
                class_243 start = interpolatedJoints.get(k);
                class_243 end = interpolatedJoints.get(k + 1);

                // Appliquer swing et vertical offset à la main (dernier segment)
                if (k == interpolatedJoints.size() - 2) {
                    end = end.method_1031(swing, handArc + vertical, -0.08 * (1.0 - progress));
                }

                var segBone = model.getBone("seg" + (k + 1) + "_arm" + (i + 1));
                if (segBone.isEmpty()) return;
                BoneAccessor segAcc = segBone.get();
                segAcc.moveTo(start, end, entity);

                BoneAccessor armSegmentAccessor = model.getBone("seg" + (k + 1) + "_arm" + (i + 1)).get();
                class_243 modelPosWorldSpace = limbChain.getJoints().get(k);
                class_243 targetVecWorldSpace = limbChain.getJoints().get(k + 1);

                // Décalage debug
                if (com.sp.entity.ik.util.PrAnCommonClass.shouldRenderDebugLegs) {
                    modelPosWorldSpace = modelPosWorldSpace.method_1023(0.0, 200.0, 0.0);
                    targetVecWorldSpace = targetVecWorldSpace.method_1023(0.0, 200.0, 0.0);
                }

                armSegmentAccessor.moveTo(modelPosWorldSpace, targetVecWorldSpace, entity);
            }
        }
    }

    @Override
    public void getModelPositions(E animatable, ModelAccessor model) {
        for (int i = 0; i < this.limbs.size(); i++) {
            var optBone = model.getBone("base_arm" + (i + 1));
            if (optBone.isEmpty()) return;
            BoneAccessor baseAcc = optBone.get();
            this.bases.set(i, baseAcc.getPosition());
        }
    }

    @Override
    public void tickServer(E animatable) {
        super.tickServer(animatable);
        class_1314 entity = (class_1314) animatable;
        class_243 pos = entity.method_19538();
        for (int i = 0; i < endPoints.size(); i++) {
            ServerLimb limb = endPoints.get(i);
            limb.tick(this, i, this.settings.get(i).movementSpeed());
            class_243 offset = limb.baseOffset.method_1021(this.getScale());

            if (hasMovedOverLastTick(entity)) {
                offset = offset.method_1031(0, 0, Math.min(settings.get(i).stepInFront() * this.getScale(), 0.18));
            }
            offset = offset.method_1024((float) Math.toRadians(-entity.method_43078()));
            class_243 worldBase = offset.method_1019(pos);
            var hit = rayCastToGround(worldBase, entity, settings.get(i).fluid());
            class_243 target = hit.method_17784();

            target = adjustForWall(entity, worldBase, target);

            double prog = stepProgress.get(i);
            if (limb.hasToBeSet) {
                boolean otherMoving = false;
                for (int j = 0; j < stepProgress.size(); j++) {
                    if (j != i && stepProgress.get(j) < 1.0) {
                        otherMoving = true;
                        break;
                    }
                }
                if (!otherMoving) {
                    prog = 0.0;
                    limb.set(target);
                    limb.hasToBeSet = false;
                }
            } else if (!target.method_24802(limb.target, this.getMaxArmFormTargetDistance(entity))) {
                boolean otherMoving = false;
                for (int j = 0; j < stepProgress.size(); j++) {
                    if (j != i && stepProgress.get(j) < 1.0) {
                        otherMoving = true;
                        break;
                    }
                }
                if (!otherMoving) {
                    prog = 0.0;
                    limb.setTarget(target);
                }
            } else {
                prog = Math.min(prog + 0.035, 1.0);
            }
            stepProgress.set(i, prog);
        }
    }

    @Override
    public C setLimb(int index, class_243 base, class_1297 entity) {
        C limb = super.setLimb(index, base, entity);
        if (limb instanceof net.dark.spv_addon.entities.ik.parts.ik_chains.EntityArm arm) arm.entity = entity;
        return limb;
    }

    public void renderDebug(class_4587 poseStack, E animatable, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        if (com.sp.entity.ik.util.PrAnCommonClass.shouldRenderDebugLegs) {
            for (int i = 0; i < this.limbs.size(); ++i) {
                C limb = this.limbs.get(i);
                List<class_243> joints = limb.getJoints();
                for (int k = 0; k < joints.size() - 1; ++k) {
                    class_243 start = joints.get(k).method_1023(0, 200, 0);
                    class_243 end = joints.get(k + 1).method_1023(0, 200, 0);
                }
            }
        }
        new com.sp.entity.ik.components.debug_renderers.LegDebugRenderer<E, C>()
                .renderDebug(this, animatable, poseStack, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
    }

    public double getMaxArmFormTargetDistance(class_1314 entity) {
        if (stillStandCounter >= settings.get(0).standStillCounter() && hasMovedOverLastTick(entity)) {
            stillStandCounter = 0;
        } else if (stillStandCounter < settings.get(0).standStillCounter()) {
            stillStandCounter++;
        }
        return (stillStandCounter == settings.get(0).standStillCounter()
                ? settings.get(0).maxStandingStillDistance() * 0.5
                : settings.get(0).maxDistance() * 0.4)
                * this.getScale();
    }
}