// src/main/java/net/dark/spv_addon/entities/ik/components/IKLegCompDark.java
package net.dark.spv_addon.entities.ik.components;

import com.sp.entity.ik.components.IKAnimatable;
import com.sp.entity.ik.components.debug_renderers.LegDebugRenderer;
import com.sp.entity.ik.model.BoneAccessor;
import com.sp.entity.ik.model.ModelAccessor;
import com.sp.entity.ik.parts.ik_chains.EntityLeg;
import com.sp.entity.ik.parts.ik_chains.IKChain;
import com.sp.entity.ik.parts.sever_limbs.ServerLimb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class IKLegCompDark<C extends IKChain, E extends IKAnimatable<E>>
        extends com.sp.entity.ik.components.IKLegComponent<C, E> {

    private final List<ServerLimb> endPoints;
    private final List<class_243> bases;
    private final List<LegSetting> settings;
    private final List<Double> stepProgress = new ArrayList<>();
    private int stillStandCounter = 0;
    private class_243 armTarget = null;

    @SafeVarargs
    public IKLegCompDark(List<LegSetting> settings, List<ServerLimb> endpoints, C... limbs) {
        super(settings, endpoints, limbs);
        this.endPoints = endpoints;
        this.bases = new ArrayList<>();
        this.settings = settings;
        Arrays.stream(limbs).forEach(limb -> this.bases.add(class_243.field_1353));
        for (int i = 0; i < endpoints.size(); i++) stepProgress.add(0.0);
    }

    private static boolean hasMovedOverLastTick(class_1314 entity) {
        class_243 vel = entity.method_18798();
        float yawDelta = Math.abs(entity.method_5791() - entity.field_6259);
        return vel.field_1352 != 0 || vel.field_1350 != 0 || yawDelta >= 0.01F;
    }

    public static class_3965 rayCastToGround(class_243 rotatedLimbOffset, class_1297 entity, class_3959.class_242 fluid) {
        class_1937 world = entity.method_37908();
        return world.method_17742(
                new class_3959(
                        rotatedLimbOffset.method_43206(class_2350.field_11036, 3),
                        rotatedLimbOffset.method_43206(class_2350.field_11033, 10),
                        class_3959.class_3960.field_17558,
                        fluid,
                        entity
                )
        );
    }

    public void setArmTarget(double x, double y, double z) {
        this.armTarget = new class_243(x, y, z);
    }

    // Empêche la jambe d'aller dans un mur (collision latérale)
    private class_243 adjustForWall(class_1314 entity, class_243 from, class_243 to) {
        class_1937 world = entity.method_37908();
        class_243 dir = to.method_1020(from);
        double dist = dir.method_1033();
        if (dist < 0.01) return to;
        dir = dir.method_1029();
        class_243 checkTo = from.method_1019(dir.method_1021(dist + 0.2));
        class_3965 hit = world.method_17742(new class_3959(
                from, checkTo,
                class_3959.class_3960.field_17558,
                class_3959.class_242.field_1348,
                entity
        ));
        if (hit.method_17783() == class_3965.Type.field_1332) {
            return hit.method_17784().method_1020(dir.method_1021(0.1));
        }
        return to;
    }

    @Override
    public void tickClient(E animatable, ModelAccessor model) {
        class_1297 entity = (class_1297) animatable;
        long age = entity.field_6012;
        for (int i = 0; i < this.limbs.size(); i++) {
            var optBone = model.getBone("base_leg" + (i + 1));
            if (optBone.isEmpty()) return;
            class_243 basePos = this.bases.get(i);
            C limbChain = this.setLimb(i, basePos, entity);

            double breathing = Math.sin((age + i * 10) * 0.04) * 0.07;

            double progress = stepProgress.get(i);
            double bumpHeight = 0.2;
            if (progress < 1.0) {
                double t = 0.5 - 0.5 * Math.cos(Math.PI * progress);
                bumpHeight = Math.sin(Math.PI * t) * 0.19 + breathing;
            } else {
                bumpHeight = breathing;
            }

            for (int k = 0; k < limbChain.getJoints().size() - 1; k++) {
                class_243 start = limbChain.getJoints().get(k);
                class_243 end = limbChain.getJoints().get(k + 1);
                if (k == limbChain.getJoints().size() - 2) {
                    end = end.method_1031(0, bumpHeight, 0);
                }
                var segBone = model.getBone("seg" + (k + 1) + "_leg" + (i + 1));
                if (segBone.isEmpty()) return;
                BoneAccessor segAcc = segBone.get();
                segAcc.moveTo(start, end, entity);
            }
        }
        if (armTarget != null) {
            for (int i = 0; i < this.limbs.size(); i++) {
                var optArmBone = model.getBone("arm_base" + (i + 1));
                if (optArmBone.isEmpty()) continue;
                C armChain = this.setLimb(i, this.bases.get(i), entity);
                armChain.getJoints().set(armChain.getJoints().size() - 1, armTarget);
                for (int k = 0; k < armChain.getJoints().size() - 1; k++) {
                    class_243 start = armChain.getJoints().get(k);
                    class_243 end = armChain.getJoints().get(k + 1);
                    var segBone = model.getBone("seg" + (k + 1) + "_arm" + (i + 1));
                    if (segBone.isEmpty()) continue;
                    BoneAccessor segAcc = segBone.get();
                    segAcc.moveTo(start, end, entity);
                }
            }
        }
    }

    @Override
    public void getModelPositions(E animatable, ModelAccessor model) {
        for (int i = 0; i < this.limbs.size(); i++) {
            var optBone = model.getBone("base_leg" + (i + 1));
            if (optBone.isEmpty()) return;
            BoneAccessor baseAcc = optBone.get();
            this.bases.set(i, baseAcc.getPosition());
        }
    }

    @Override
    public void tickServer(E animatable) {
        super.tickServer(animatable);
        class_1314 entity = (class_1314) animatable;
        class_243 pos = entity.method_19538();
        for (int i = 0; i < endPoints.size(); i++) {
            ServerLimb limb = endPoints.get(i);
            limb.tick(this, i, this.settings.get(i).movementSpeed());
            class_243 offset = limb.baseOffset.method_1021(this.getScale());
            if (hasMovedOverLastTick(entity)) {
                offset = offset.method_1031(0, 0, settings.get(i).stepInFront() * this.getScale());
            }
            offset = offset.method_1024((float) Math.toRadians(-entity.method_43078()));
            class_243 worldBase = offset.method_1019(pos);
            var hit = rayCastToGround(worldBase, entity, settings.get(i).fluid());
            class_243 target = hit.method_17784();

            target = adjustForWall(entity, worldBase, target);

            double prog = stepProgress.get(i);
            if (limb.hasToBeSet) {
                prog = 0.0;
                limb.set(target);
                limb.hasToBeSet = false;
            } else if (!target.method_24802(limb.target, this.getMaxLegFormTargetDistance(entity))) {
                prog = 0.0;
                limb.setTarget(target);
            } else {
                prog = Math.min(prog + 0.045, 1.0);
            }
            stepProgress.set(i, prog);
        }
    }

    @Override
    public C setLimb(int index, class_243 base, class_1297 entity) {
        C limb = super.setLimb(index, base, entity);
        if (limb instanceof EntityLeg leg) leg.entity = entity;
        return limb;
    }

    public void renderDebug(class_4587 stack, E animatable,
                            class_1921 layer, class_4597 pipes,
                            class_4588 vb, float pt, int light, int overlay) {
        new LegDebugRenderer<E, C>()
                .renderDebug(this, animatable, stack, layer, pipes, vb, pt, light, overlay);
    }

    public double getMaxLegFormTargetDistance(class_1314 entity) {
        if (stillStandCounter >= settings.get(0).standStillCounter() && hasMovedOverLastTick(entity)) {
            stillStandCounter = 0;
        } else if (stillStandCounter < settings.get(0).standStillCounter()) {
            stillStandCounter++;
        }
        return (stillStandCounter == settings.get(0).standStillCounter()
                ? settings.get(0).maxStandingStillDistance()
                : settings.get(0).maxDistance())
                * this.getScale();
    }
}