package net.dark.spv_addon.init.cutscene;

import foundry.veil.api.client.anim.Keyframe;
import foundry.veil.api.client.anim.Path;
import foundry.veil.api.client.util.Easings.Easing;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1297.class_5529;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class WindowCutsceneManager {
    private final int duration = 2500;
    private final class_310 client = class_310.method_1551();
    private long startTime;
    private Path cameraPathPos;
    private Path cameraPathRotX;
    private Path cameraPathRotY;
    private Path cameraPathRotZ;
    private class_1297 camera = null;

    public void start() {
        if (client.field_1724 == null || client.field_1687 == null) return;
        this.startTime = System.currentTimeMillis();
        class_243 startPos = client.field_1724.method_19538();
        class_243 endPos = startPos.method_1019(client.field_1724.method_5828(1.0F).method_1021(1)).method_1031(0, -0.5, 0); // avance d'1 bloc devant et descend de 0.5 bloc
        class_243 startRot = new class_243(client.field_1724.method_36455(), client.field_1724.method_36454(), 0);
        class_243 endRot = new class_243(client.field_1724.method_36455() - 30, client.field_1724.method_36454(), 15); // regarde un peu plus vers le haut et roule de 15 degrés

        this.cameraPathPos = new Path(List.of(
                new Keyframe(startPos, class_243.field_1353, class_243.field_1353, 0, Easing.easeOutQuad),
                new Keyframe(endPos, class_243.field_1353, class_243.field_1353, duration, Easing.easeInQuad)
        ), false, false);

        this.cameraPathRotX = new Path(List.of(
                new Keyframe(class_243.field_1353, new class_243(startRot.field_1352, 0, 0), class_243.field_1353, 0, Easing.easeOutQuad),
                new Keyframe(class_243.field_1353, new class_243(endRot.field_1352, 0, 0), class_243.field_1353, duration, Easing.easeInQuad)
        ), false, false);

        this.cameraPathRotY = new Path(List.of(
                new Keyframe(class_243.field_1353, new class_243(0, startRot.field_1351, 0), class_243.field_1353, 0, Easing.easeOutQuad),
                new Keyframe(class_243.field_1353, new class_243(0, endRot.field_1351, 0), class_243.field_1353, duration, Easing.easeInQuad)
        ), false, false);

        this.cameraPathRotZ = new Path(List.of(
                new Keyframe(class_243.field_1353, new class_243(0, 0, 0), class_243.field_1353, 0, Easing.easeOutQuad),
                new Keyframe(class_243.field_1353, new class_243(0, 0, endRot.field_1350), class_243.field_1353, duration, Easing.easeInQuad)
        ), false, false);

        if (this.camera != null) {
            this.camera.method_5650(class_5529.field_26999);
        }
        this.camera = new class_1542(client.field_1687, startPos.field_1352, startPos.field_1351, startPos.field_1350, class_1799.field_8037);
        this.camera.method_5808(startPos.field_1352, startPos.field_1351, startPos.field_1350, (float) startRot.field_1351, (float) startRot.field_1352);
    }

    public void tick() {
        if (client.field_1724 == null || client.field_1687 == null || this.camera == null) return;
        float timer = (float) (System.currentTimeMillis() - this.startTime) / (float) this.duration;
        timer = class_3532.method_15363(timer, 0.0F, 0.9999F);

        double interp = timer;
        class_243 prevPos = cameraPathPos.frameAtProgress(0).getPosition();
        class_243 nextPos = cameraPathPos.frameAtProgress(0.9999F).getPosition();
        class_243 pos = new class_243(
                class_3532.method_16436(interp, prevPos.field_1352, nextPos.field_1352),
                class_3532.method_16436(interp, prevPos.field_1351, nextPos.field_1351),
                class_3532.method_16436(interp, prevPos.field_1350, nextPos.field_1350)
        );

        class_243 prevRot = new class_243(
                cameraPathRotX.frameAtProgress(0).getRotation().field_1352,
                cameraPathRotY.frameAtProgress(0).getRotation().field_1351,
                cameraPathRotZ.frameAtProgress(0).getRotation().field_1350
        );
        class_243 nextRot = new class_243(
                cameraPathRotX.frameAtProgress(0.9999F).getRotation().field_1352,
                cameraPathRotY.frameAtProgress(0.9999F).getRotation().field_1351,
                cameraPathRotZ.frameAtProgress(0.9999F).getRotation().field_1350
        );
        class_243 rot = new class_243(
                class_3532.method_16436(interp, prevRot.field_1352, nextRot.field_1352),
                class_3532.method_16436(interp, prevRot.field_1351, nextRot.field_1351),
                class_3532.method_16436(interp, prevRot.field_1350, nextRot.field_1350)
        );

        this.camera.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, (float) rot.field_1351, (float) rot.field_1352);
        this.client.field_1719 = this.camera;
    }

    public void stop() {
        if (this.camera != null) {
            this.camera.method_5650(class_5529.field_26999);
            this.camera = null;
        }
        if (client.field_1724 != null) {
            client.field_1719 = client.field_1724;
        }
    }

    public boolean isFinished() {
        float timer = (float) (System.currentTimeMillis() - this.startTime) / (float) this.duration;
        return timer >= 1.0F;
    }
}