package net.dark.spv_addon.items.custom;

import net.dark.spv_addon.Additions.api.SanityLightStore;
import net.dark.spv_addon.Additions.thirst.ThirstManager;
import net.dark.spv_addon.cca.InitializeComponents;
import net.dark.spv_addon.cca.SanityComponent;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class SanityRestoringItem extends class_1792 {
    private final int sanityChange;
    private final int thirstChange;
    private final boolean poisoned;
    private final boolean decreaseSanity;
    private final boolean decreaseThirst;

    /**
     * @param settings       Item settings
     * @param sanityChange   Amount of sanity to change (positive or negative)
     * @param thirstChange   Amount of thirst to change (positive or negative)
     * @param poisoned       Whether the item causes poison effect
     * @param decreaseSanity Whether the item decreases sanity
     * @param decreaseThirst Whether the item decreases thirst
     */

    public SanityRestoringItem(class_1793 settings, int sanityChange, int thirstChange, boolean poisoned, boolean decreaseSanity, boolean decreaseThirst) {
        super(settings);
        this.sanityChange = sanityChange;
        this.thirstChange = thirstChange;
        this.poisoned = poisoned;
        this.decreaseSanity = decreaseSanity;
        this.decreaseThirst = decreaseThirst;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        SanityComponent sanity = InitializeComponents.SANITY.get(player);

        if (!world.field_9236) {
            if (thirstChange != 0) {
                int value = decreaseThirst ? -Math.abs(thirstChange) : Math.abs(thirstChange);
                ThirstManager.increaseThirst(player, value);
            }
            if (sanityChange != 0) {
                if (!SanityLightStore.isPlayerInLightRange(world, player)) {
                    int value = decreaseSanity ? -Math.abs(sanityChange) : Math.abs(sanityChange);
                    if (value > 0) {
                        sanity.increaseSanity(value);
                    } else {
                        sanity.decreaseSanity(-value);
                    }
                }
            }
            stack.method_7934(1);

            if (poisoned) {
                player.method_6092(new net.minecraft.class_1293(
                        net.minecraft.class_1294.field_5899,
                        100,
                        0,
                        true,
                        false
                ));
            }
        }
        return class_1271.method_29237(stack, world.method_8608());

    }
}
