package net.dark.spv_addon.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sp.SPBRevampedClient;
import com.sp.render.camera.CutsceneManager;
import com.sp.render.gui.TitleText;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(TitleText.class)
public class TitleTextMixin {

    @Inject(method = "onHudRender", at = @At("TAIL"))
    private void injectVolatileCredit(class_332 drawContext, float tickDelta, CallbackInfo ci) {
        CutsceneManager cutsceneManager = SPBRevampedClient.getCutsceneManager();
        if (!cutsceneManager.backroomsBySP || cutsceneManager.blackScreen.isBlackScreen) return;

        class_310 client = class_310.method_1551();
        if (client == null || client.field_1772 == null) return;

        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();

        class_2561 prefix = class_2561.method_43470("and The Volatile Addon Made by: ").method_27692(class_124.field_1079);
        class_2561 suffix = class_2561.method_43470("DarkFox Studios").method_27692(class_124.field_1064);

        String fullText = prefix.getString() + suffix.getString();
        int fullWidth = client.field_1772.method_1727(fullText);

        float scale = 0.8F;
        int yOffset = (screenHeight / 2) + 20;

        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();

        // Center scaling from middle
        matrices.method_46416(screenWidth / 2f, yOffset, 0);
        matrices.method_22905(scale, scale, scale);
        matrices.method_46416(-fullWidth / 2f, 0, 0);

        RenderSystem.enableBlend();
        drawContext.method_51439(client.field_1772, prefix, 0, 0, 0xDC143C, true);
        drawContext.method_51439(client.field_1772, suffix, client.field_1772.method_1727(prefix.getString()), 0, 0xAA00FF, true);
        RenderSystem.disableBlend();

        matrices.method_22909();
    }
}
