package net.dark.spv_addon.mixins.blocks;

import com.sp.block.entity.CeilingLightBlockEntity;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import net.dark.spv_addon.init.BackroomsLevels;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(CeilingLightBlockEntity.class)
public abstract class CeilingLightBlockEntityMixin {

    @Shadow
    AreaLight light;

    @Shadow
    float brightness;

    @Shadow
    float angle;

    /**
     * Injects additional logic into the tick method at the tail end.
     */
    @Inject(method = "tick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V",
            at = @At("TAIL"))
    private void tickInject(class_1937 world, class_2338 pos, class_2680 state, CallbackInfo ci) {
        if (world.field_9236) {
            if (world.method_27983().equals(BackroomsLevels.LEVEL_KITTY_WORLD_KEY)) {
                light.setBrightness(brightness);
                light.setAngle((float) Math.toRadians(angle));
                light.setColor(1.0F, 0.0F, 0.8F);

                System.out.println("[Mixin] Adjusted light properties for Kitty world.");
            }
        }
    }
}
