package net.dark.spv_addon.mixins.blocks;

import com.sp.block.entity.FluorescentLightBlockEntity;
import com.sp.clientWrapper.ClientWrapper;
import net.dark.spv_addon.init.BackroomsLevels;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ClientWrapper.class)
public abstract class ClientWrapperMixin {

    @Inject(method = "doClientSideTick", at = @At("TAIL"))
    private static void onClientTick(class_1937 world, class_2338 pos, class_2680 state, FluorescentLightBlockEntity block, CallbackInfo ci) {
        if (!world.field_9236) return;


        if (world.method_27983().equals(BackroomsLevels.LEVEL_KITTY_WORLD_KEY)) {
            if (block.pointLight != null) {
                block.pointLight.setColor(0.631f, 0.102f, 0.631f).setRadius(10);
            }
        }
    }
}
