package net.dark.spv_addon.world.events;

import net.dark.spv_addon.init.BackroomsLevels;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

import static com.sp.init.BackroomsLevels.LEVEL0_WORLD_KEY;
import static com.sp.init.BackroomsLevels.LEVEL1_WORLD_KEY;
import static net.dark.spv_addon.init.BackroomsLevels.LEVELRUN_WORLD_KEY;

public class LevelRunGlobalTicker {
    private static final boolean IS_DEV = java.lang.management.ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    private static final int TICKS_PER_MIN = 20 * 60;
    private static int globalTimerTicks = -1;
    private static boolean alreadyActivated = false;

    public static void init() {
        net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents.END_SERVER_TICK.register(LevelRunGlobalTicker::onServerTick);
    }

    private static void onServerTick(MinecraftServer server) {
        boolean anyPlayerInBackrooms = false;
        Set<class_3222> playersInBackrooms = new HashSet<>();
        class_3222 plushieHolder = null;

        for (class_3222 player : server.method_3760().method_14571()) {
            class_5321<class_1937> key = player.method_37908().method_27983();
            if (key.equals(LEVEL0_WORLD_KEY) || key.equals(LEVEL1_WORLD_KEY)) {
                anyPlayerInBackrooms = true;
                playersInBackrooms.add(player);

                if (plushieHolder == null) {
                    for (int i = 0; i < player.method_31548().method_5439(); i++) {
                        if (player.method_31548().method_5438(i).method_31574(net.dark.spv_addon.init.ModBlocks.KITTY_PLUSHIE.method_8389())) {
                            plushieHolder = player;
                            break;
                        }
                    }
                }
            }
        }

        if (!alreadyActivated && anyPlayerInBackrooms) {
            int delay = IS_DEV ? TICKS_PER_MIN : (5 * TICKS_PER_MIN) + new Random().nextInt(6 * TICKS_PER_MIN);
            globalTimerTicks = delay;
            alreadyActivated = true;
            if (IS_DEV) {
                System.out.println("[SPV_ADDON] Global LevelRun timer started for " + (delay / 20) + "s.");
            }
        }

        if (globalTimerTicks > 0) {
            globalTimerTicks--;
            if (globalTimerTicks == 0) {
                if (IS_DEV) {
                    System.out.println("[SPV_ADDON] Global LevelRun timer expired! Noclipping...");
                }
                boolean goKitty = plushieHolder != null;

                // Remove plushie from holder (1 item only)
                if (goKitty) {
                    for (int i = 0; i < plushieHolder.method_31548().method_5439(); i++) {
                        if (plushieHolder.method_31548().method_5438(i).method_31574(net.dark.spv_addon.init.ModBlocks.KITTY_PLUSHIE1.method_8389())) {
                            plushieHolder.method_31548().method_5434(i, 1);
                            break;
                        }
                    }
                }

                for (class_3222 player : playersInBackrooms) {
                    if (goKitty) {
                        noclipPlayerToKitty(player);
                        if (IS_DEV) {
                            System.out.println("[SPV_ADDON] " + player.method_5820() + " was sent to LEVEL_KITTY.");
                        }
                    } else {
                        noclipPlayerToLevelRun(player);
                        if (IS_DEV) {
                            System.out.println("[SPV_ADDON] " + player.method_5820() + " was sent to LEVEL_RUN.");
                        }
                    }
                }

                globalTimerTicks = -1;
                alreadyActivated = false;
            }
        }

        if (alreadyActivated && !anyPlayerInBackrooms) {
            alreadyActivated = false;
            globalTimerTicks = -1;
        }
    }


    private static void noclipPlayerToLevelRun(class_3222 player) {
        com.sp.SPBRevamped.sendBlackScreenPacket(player, 60, true, false);
        player.method_5682().execute(() -> {
            class_3218 runWorld = player.method_5682().method_3847(LEVELRUN_WORLD_KEY);
            if (runWorld != null) {
                player.method_14251(runWorld, 7.5, 1, 7.5, player.method_36454(), player.method_36455());
            }
        });
    }

    private static void noclipPlayerToKitty(class_3222 player) {
        com.sp.SPBRevamped.sendBlackScreenPacket(player, 60, true, false);
        player.method_5682().execute(() -> {
            class_3218 kittyWorld = player.method_5682().method_3847(BackroomsLevels.LEVEL_KITTY_WORLD_KEY);
            if (kittyWorld != null) {
                player.method_14251(kittyWorld, 21, 2, 13, 0, -90);
            }
        });
    }
}