package net.dark.spv_addon.world.events.level207;

import com.sp.world.events.AbstractEvent;
import net.dark.spv_addon.init.ModSounds;
import net.minecraft.class_1937;
import net.minecraft.class_3419;

public class Level207AmbienceEvent extends AbstractEvent {
    private static final int AMBIENCE_INTERVAL = 440; // duration in ticks (20 ticks = 1 second, 400 = 20 sec)
    private int ticks = 0;

    @Override
    public void init(class_1937 world) {
        playAmbience(world);
        this.ticks = 0;
    }

    @Override
    public void ticks(int ticks, class_1937 world) {
        this.ticks++;
        // Loop sound every interval
        if (this.ticks % AMBIENCE_INTERVAL == 0) {
            playAmbience(world);
        }
    }

    private void playAmbience(class_1937 world) {
        // Play for all players in the dimension
        world.method_18456().forEach(player -> {
            player.method_17356(ModSounds.LEVEL_207_AMBIANCE, class_3419.field_15256, 1.0F, 1.0F);
        });
    }

    @Override
    public int duration() {
        return Integer.MAX_VALUE; // Run "forever" (until the player leaves or level changes)
    }
}
