package net.dark.spv_addon.world.events.level207;

import com.sp.world.events.AbstractEvent;
import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.dark.spv_addon.init.ModEntities;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class Level207BellWalkerEvent extends AbstractEvent {
    private static final int EVENT_DELAY_TICKS = 20 * 60 * 3; // 3 minutes
    private final class_5819 random = class_5819.method_43047();
    private int ticks = 0;
    private class_3218 world;
    private class_243 spawnPos;

    public Level207BellWalkerEvent() {
        // Constructeur par défaut
    }

    // Appelée automatiquement par le système d'event après l'ajout
    public void init(class_1937 world) {
        if (world instanceof class_3218 serverWorld) {
            this.world = serverWorld;
            // Choisissez une position de spawn adaptée à votre niveau
            this.spawnPos = new class_243(7, 66, 7); // exemple : spawn du niveau 207
        }
    }

    @Override
    public int duration() {
        return 1;
    }

    public void tick() {
        if (world == null || spawnPos == null) return;
        ticks++;
        if (ticks >= EVENT_DELAY_TICKS) {
            ticks = 0;
            spawnBellWalkers();
        }
    }

    private void spawnBellWalkers() {
        int count = 2 + random.method_43048(3); // 2 à 4
        for (int i = 0; i < count; i++) {
            double dx = spawnPos.field_1352 + random.method_39332(-10, 10);
            double dz = spawnPos.field_1350 + random.method_39332(-10, 10);
            double dy = spawnPos.field_1351;
            BellWalkerEntity bellWalker = new BellWalkerEntity(ModEntities.SIX_LEG_ENTITY, world);
            bellWalker.method_5808(dx, dy, dz, 0, 0);
            world.method_8649(bellWalker);
        }
    }
}