package net.dark.spv_addon.world.events.level207;


import net.dark.spv_addon.init.BackroomsLevels;
import net.dark.spv_addon.world.levels.custom.Level207BackroomsLevel;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

// Classe utilitaire pour tracker les déplacements des joueurs dans le Level 207
public class Level207MoveTracker {
    private static final Map<UUID, class_243> lastPositions = new HashMap<>();

    public static void register(Level207BackroomsLevel level207) {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!player.method_37908().method_27983().equals(BackroomsLevels.LEVEL207_WORLD_KEY)) continue;
                class_243 current = player.method_19538();
                class_243 last = lastPositions.get(player.method_5667());
                if (last == null) {
                    lastPositions.put(player.method_5667(), current);
                    continue;
                }
                if (!current.equals(last)) {
                    level207.onPlayerMove(player, last, current);
                    lastPositions.put(player.method_5667(), current);
                }
            }
        });
    }
}