package net.dark.spv_addon.world.generation.ikea;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sp.SPBRevampedClient;
import com.sp.world.generation.BackroomsChunkGenerator;
import net.dark.spv_addon.Spv_addon;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.server.MinecraftServer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public final class LevelIKEAChunkGenerator extends BackroomsChunkGenerator {
    public static final Codec<LevelIKEAChunkGenerator> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_1966.field_24713.fieldOf("biome_source").forGetter(gen -> gen.field_12761),
                    class_5284.field_24781.fieldOf("settings").forGetter(gen -> gen.settings)
            ).apply(instance, LevelIKEAChunkGenerator::new)
    );


    private final class_6880<class_5284> settings;
    private final class_5819 random = class_5819.method_43047();

    public LevelIKEAChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
        super(biomeSource);
        this.settings = settings;
    }

    @Override
    protected Codec<? extends class_2794> method_28506() {
        return field_24746;
    }

    @Override
    public void generate(class_5281 world, class_2791 chunk) {
        this.method_12102(world, chunk, null);
    }

    @Override
    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        int cx = chunk.method_12004().field_9181;
        int cz = chunk.method_12004().field_9180;

        MinecraftServer server = world.method_8503();
        if (server == null) return;
        class_3485 mgr = server.method_27727();

        int gridSize = 32;

        for (int gx = 0; gx < 128; gx++) {
            for (int gz = 0; gz < 128; gz++) {
                int px = gx * 32;
                int pz = gz * 32;
                int chunkX = px / 16;
                int chunkZ = pz / 16;
                if (chunkX == cx && chunkZ == cz) {
                    String pathName = "ikea/pathway_room" + (((gx + gz) % 4) + 1);
                    class_2960 pathId = new class_2960(Spv_addon.MOD_ID, pathName);
                    Optional<class_3499> optPath = mgr.method_15094(pathId);
                    if (optPath.isPresent()) {
                        class_2338 pathPos = new class_2338(px, 0, pz);
                        class_3492 pathData = new class_3492()
                                .method_15125(class_2415.field_11302)
                                .method_15133(true);
                        optPath.get().method_15172(world, pathPos, pathPos, pathData, random, 2);
                    }
                }
                int rightPx = px + 32;
                int rightChunkX = rightPx / 16;
                int rightChunkZ = pz / 16;
                if (rightChunkX == cx && rightChunkZ == cz) {
                    String miscName = "ikea/misc_room" + (((gx + gz) % 4) + 1);
                    class_2960 miscId = new class_2960(Spv_addon.MOD_ID, miscName);
                    Optional<class_3499> optMisc = mgr.method_15094(miscId);
                    if (optMisc.isPresent()) {
                        class_2338 miscPos = new class_2338(rightPx, 0, pz);
                        class_3492 miscData = new class_3492()
                                .method_15125(class_2415.field_11302)
                                .method_15123(class_2470.values()[random.method_43048(class_2470.values().length)])
                                .method_15133(true);
                        optMisc.get().method_15172(world, miscPos, miscPos, miscData, random, 2);
                    }
                }
                // Génération des salles à gauche
                int leftPx = px - 32;
                int leftChunkX = leftPx / 16;
                int leftChunkZ = pz / 16;
                if (leftChunkX == cx && leftChunkZ == cz) {
                    String miscName = "ikea/misc_room" + (((gx + gz + 2) % 4) + 1);
                    class_2960 miscId = new class_2960(Spv_addon.MOD_ID, miscName);
                    Optional<class_3499> optMisc = mgr.method_15094(miscId);
                    if (optMisc.isPresent()) {
                        class_2338 miscPos = new class_2338(leftPx, 0, pz);
                        class_3492 miscData = new class_3492()
                                .method_15125(class_2415.field_11302)
                                .method_15123(class_2470.values()[random.method_43048(class_2470.values().length)])
                                .method_15133(true);
                        optMisc.get().method_15172(world, miscPos, miscPos, miscData, random, 2);
                    }
                }
            }
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                String roofName = random.method_43056() ? "ikea/roof1" : "ikea/roof2";
                class_2960 roofId = new class_2960(Spv_addon.MOD_ID, roofName);
                Optional<class_3499> optRoof = mgr.method_15094(roofId);
                if (optRoof.isEmpty()) continue;

                int bx = chunk.method_12004().method_8326();
                int bz = chunk.method_12004().method_8328();
                int px = bx + 8 * i;
                int pz = bz + 8 * j;

                class_2338 roofPos = new class_2338(px, 10, pz);

                class_3492 roofData = new class_3492()
                        .method_15125(class_2415.field_11302)
                        .method_15123(class_2470.field_11467)
                        .method_15133(true);

                optRoof.get().method_15172(world, roofPos, roofPos, roofData, random, 16);
            }
        }

    }

    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender,
                                                  class_7138 noiseConfig,
                                                  class_5138 structureAccessor,
                                                  class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public int method_12104() {
        return 256;
    }

    @Override
    public int method_16397(int x, int z, net.minecraft.class_2902.class_2903 type,
                         net.minecraft.class_5539 view,
                         class_7138 noiseConfig) {
        return method_12104();
    }

    @Override
    public class_4966 method_26261(int x, int z,
                                               net.minecraft.class_5539 view,
                                               class_7138 noiseConfig) {
        var states = new net.minecraft.class_2680[method_12104()];
        for (int i = 0; i < states.length; i++) {
            states[i] = class_2246.field_10124.method_9564();
        }
        return new class_4966(0, states);
    }

    @Override
    public void method_12108(class_3233 region, long seed,
                      class_7138 noiseConfig, net.minecraft.class_4543 biomeAccess,
                      class_5138 structAcc, class_2791 chunk,
                      class_2893.class_2894 carverStep) {
    }

    @Override
    public void method_12110(class_3233 region,
                             class_5138 structAcc,
                             class_7138 noiseConfig,
                             class_2791 chunk) {
    }

    @Override
    public void method_12107(class_3233 region) {
    }

    @Override
    public void method_40450(java.util.List<String> text,
                                class_7138 noiseConfig,
                                class_2338 pos) {
    }
}
