package net.dark.spv_addon.world.generation.level207;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sp.SPBRevampedClient;
import com.sp.world.generation.BackroomsChunkGenerator;
import net.dark.spv_addon.Spv_addon;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.server.MinecraftServer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public final class Level207ChunkGenerator extends BackroomsChunkGenerator {
    public static final Codec<Level207ChunkGenerator> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_1966.field_24713.fieldOf("biome_source").forGetter(gen -> gen.field_12761),
                    class_5284.field_24781.fieldOf("settings").forGetter(gen -> gen.settings)
            ).apply(instance, Level207ChunkGenerator::new)
    );

    private final class_6880<class_5284> settings;
    private final class_5819 random = class_5819.method_43047();

    public Level207ChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
        super(biomeSource);
        this.settings = settings;
        SPBRevampedClient.setInBackrooms(true);
    }

    @Override
    protected Codec<? extends class_2794> method_28506() {
        return field_24746;
    }

    @Override
    public void generate(class_5281 world, class_2791 chunk) {
        this.method_12102(world, chunk, null);
    }

    @Override
    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        int cx = chunk.method_12004().field_9181;
        int cz = chunk.method_12004().field_9180;

        if (cx % 2 == 0 && cz % 2 == 0) {
            int rx = cx / 2;
            int rz = cz / 2;

            class_2960 roomId;
            if (rx == 0 && rz == 0) {
                roomId = new class_2960(Spv_addon.MOD_ID, "level207/entrance");
            } else {
                int variant = 1 + random.method_43048(3); // 1-3 inclus
                roomId = new class_2960(Spv_addon.MOD_ID, "level207/grave" + variant);
            }

            MinecraftServer server = world.method_8503();
            if (server == null) return;
            class_3485 mgr = server.method_27727();
            Optional<class_3499> optTpl = mgr.method_15094(roomId);
            if (optTpl.isEmpty()) return;

            class_3499 template = optTpl.get();

            int limeYOffset = 0;
            for (class_3499.class_3501 info : template.method_16445(class_2338.field_10980, new class_3492(), class_2246.field_10028)) {
                limeYOffset = info.comp_1341().method_10264();
                break;
            }

            int bx = chunk.method_12004().method_8326();
            int bz = chunk.method_12004().method_8328();
            int baseY = 20 - limeYOffset;

            class_2338.class_2339 basePos = new class_2338.class_2339(bx, baseY, bz);
            class_3492 placeData = new class_3492()
                    .method_15125(class_2415.field_11302)
                    .method_15123(class_2470.field_11467)
                    .method_15133(true);

            template.method_15172(world, basePos, basePos, placeData, random, 2);
        }
    }

    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender,
                                                  class_7138 noiseConfig,
                                                  class_5138 structureAccessor,
                                                  class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Override public int method_16398() { return 0; }
    @Override public int method_33730() { return 0; }
    @Override public int method_12104() { return 256; }
    @Override public int method_16397(int x, int z, net.minecraft.class_2902.class_2903 type, net.minecraft.class_5539 view, class_7138 noiseConfig) { return method_12104(); }
    @Override public class_4966 method_26261(int x, int z, net.minecraft.class_5539 view, class_7138 noiseConfig) {
        var states = new net.minecraft.class_2680[method_12104()];
        for (int i = 0; i < states.length; i++) states[i] = class_2246.field_10124.method_9564();
        return new class_4966(0, states);
    }

    @Override
    public void method_12108(class_3233 region, long seed, class_7138 noiseConfig, net.minecraft.class_4543 biomeAccess, class_5138 structAcc, class_2791 chunk, class_2893.class_2894 carverStep) {}

    @Override
    public void method_12110(class_3233 region,
                             class_5138 structAcc,
                             class_7138 noiseConfig,
                             class_2791 chunk) {
    }

    @Override
    public void method_12107(class_3233 region) {
    }

    @Override
    public void method_40450(java.util.List<String> text,
                                class_7138 noiseConfig,
                                class_2338 pos) {
    }
}
