package net.dark.spv_addon.world.levels.custom;

import com.sp.SPBRevamped;
import com.sp.cca_stuff.InitializeComponents;
import com.sp.cca_stuff.PlayerComponent;
import com.sp.world.levels.BackroomsLevel;
import com.sp.world.levels.custom.Level1BackroomsLevel;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.DirectionalLight;
import net.dark.spv_addon.Spv_addon;
import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.dark.spv_addon.init.BackroomsLevels;
import net.dark.spv_addon.init.ModEntities;
import net.dark.spv_addon.world.events.level207.Level207AmbienceEvent;
import net.dark.spv_addon.world.events.level207.Level207BellWalkerEvent;
import net.dark.spv_addon.world.events.level207.Level207MoveTracker;
import net.dark.spv_addon.world.generation.level207.Level207ChunkGenerator;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import java.util.*;

public class Level207BackroomsLevel extends BackroomsLevel {
    private final class_5819 random = class_5819.method_43047();
    private final Map<UUID, Integer> stepsWalked = new HashMap<>();
    DirectionalLight light;
    float brightness;
    int tick;
    private int STEPS_BEFORE_WARP = 300 + random.method_43048(701);
    private boolean exitPlaced = false;

    public Level207BackroomsLevel() {
        super("level207", Level207ChunkGenerator.field_24746, new class_243(7, 66, 7), BackroomsLevels.LEVEL207_WORLD_KEY, "spv_addon");
        this.registerTransition((world, playerComponent, from) -> {
            List<BackroomsLevel.CrossDimensionTeleport> playerList = new ArrayList<>();
            if (from instanceof Level1BackroomsLevel && playerComponent.player.method_19538().method_10214() <= 12.0F && playerComponent.player.method_24828()) {
                for (class_1657 player : playerComponent.player.method_37908().method_18456()) {
                    PlayerComponent otherPlayerComponent = InitializeComponents.PLAYER.get(player);
                    double playerY = player.method_19538().method_10214();
                    if (player.method_37908().method_27983() == BackroomsLevels.LEVEL207_WORLD_KEY && playerY == 60.0 && player.method_24828()) {
                        playerList.add(new BackroomsLevel.CrossDimensionTeleport(
                                player.method_37908(),
                                otherPlayerComponent,
                                this.calculateLevel2TeleportCoords(player, playerComponent.player.method_31476()),
                                BackroomsLevels.LEVEL207_BACKROOMS_LEVEL,
                                com.sp.init.BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL
                        ));
                    }
                }
            }

            return playerList;
        }, "level207 -> poolrooms");
    }

    private class_243 calculateLevel2TeleportCoords(class_1657 player, class_1923 chunkPos) {
        if (chunkPos.field_9181 == player.method_31476().field_9181 && chunkPos.field_9180 == player.method_31476().field_9180) {
            int chunkX = chunkPos.method_8326();
            int chunkZ = chunkPos.method_8328();
            double playerX = player.method_19538().field_1352;
            double playerZ = player.method_19538().field_1350;
            return new class_243(playerX - (double) chunkX - (double) 1.0F, player.method_19538().field_1351 + (double) 8.0F, playerZ - (double) chunkZ);
        } else {
            return this.getSpawnPos();
        }
    }

    private void spawnBellWalkersAround(class_1657 player) {
        if (!(player.method_37908() instanceof class_3218 world)) return;

        for (int i = 0; i < 3; i++) {
            double offsetX = random.method_39332(-50, 50);
            double offsetZ = random.method_39332(-50, 50);
            double spawnX = player.method_23317() + offsetX;
            double spawnZ = player.method_23321() + offsetZ;
            double spawnY = player.method_23318();

            BellWalkerEntity bellWalker = new BellWalkerEntity(ModEntities.SIX_LEG_ENTITY, world);
            bellWalker.method_5808(spawnX, spawnY, spawnZ, 0, 0);
            world.method_8649(bellWalker);
        }
    }


    public void onPlayerMove(class_1657 player, class_243 oldPos, class_243 newPos) {
        if (!player.method_24828()) return;

        int steps = (int) oldPos.method_1022(newPos);
        if (steps <= 0) return;

        UUID uuid = player.method_5667();
        stepsWalked.put(uuid, stepsWalked.getOrDefault(uuid, 0) + steps);

        if (stepsWalked.get(uuid) >= STEPS_BEFORE_WARP) {
            stepsWalked.put(uuid, 0);
            PlayerComponent pc = InitializeComponents.PLAYER.get(player);

            spawnBellWalkersAround(player);

            pc.setShouldNoClip(true);
            pc.sync();
            if (!exitPlaced && stepsWalked.getOrDefault(player.method_5667(), 0) >= 200) {
                tryPlaceExitNearPlayer(player);
                exitPlaced = true;
            }


            BackroomsLevel.CrossDimensionTeleport teleport = new BackroomsLevel.CrossDimensionTeleport(
                    player.method_37908(),
                    pc,
                    this.getSpawnPos(),
                    BackroomsLevels.LEVEL207_BACKROOMS_LEVEL,
                    com.sp.init.BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL
            );

            this.transitionOut(teleport);

            player.method_5682().execute(() -> {
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException ignored) {
                }
                pc.setShouldNoClip(false);
                pc.sync();
            });

            // Réinitialisation du seuil
            STEPS_BEFORE_WARP = 300 + random.method_43048(701);
        }

        // Téléportation vers un autre niveau si le joueur tombe sous Y=30
        if (player.method_23318() < 30 && player instanceof class_3222 serverPlayer) {
            PlayerComponent pc = InitializeComponents.PLAYER.get(serverPlayer);

            pc.setShouldNoClip(true);
            pc.sync();

            BackroomsLevel.CrossDimensionTeleport teleport = new BackroomsLevel.CrossDimensionTeleport(
                    player.method_37908(),
                    pc,
                    new class_243(10, 66, 10),
                    BackroomsLevels.LEVEL207_BACKROOMS_LEVEL,
                    com.sp.init.BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL
            );

            this.transitionOut(teleport);

            player.method_5682().execute(() -> {
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException ignored) {
                }
                pc.setShouldNoClip(false);
                pc.sync();
            });
        }
    }

    private void tryPlaceExitNearPlayer(class_1657 player) {
        if (!(player.method_37908() instanceof class_3218 world)) return;

        MinecraftServer server = world.method_8503();
        if (server == null) return;

        class_3485 mgr = server.method_27727();
        class_2960 exitId = new class_2960(Spv_addon.MOD_ID, "level207/exit");
        Optional<class_3499> optTpl = mgr.method_15094(exitId);
        if (optTpl.isEmpty()) return;

        class_3499 template = optTpl.get();
        int yOffset = 0;
        for (class_3499.class_3501 info : template.method_16445(class_2338.field_10980, new class_3492(), class_2246.field_10028)) {
            if (info.comp_1342().method_27852(class_2246.field_10028)) {
                yOffset = info.comp_1341().method_10264() + 1;
                break;
            }
        }

        int radius = 20;
        int px = (int) player.method_23317() + random.method_39332(-radius, radius);
        int pz = (int) player.method_23321() + random.method_39332(-radius, radius);
        class_2338 basePos = new class_2338(px, 65 - yOffset, pz);

        class_3492 placeData = new class_3492()
                .method_15125(class_2415.field_11302)
                .method_15123(class_2470.field_11467)
                .method_15133(true);

        template.method_15172(world, basePos, basePos, placeData, random, 2);
    }


    @Override
    public void register() {
        Level207MoveTracker.register(this);
        events.add(Level207BellWalkerEvent::new);

    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            if (this.light == null) {
                this.brightness = 1F;
                this.light = new DirectionalLight();
                VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer().addLight(this.light.setBrightness(this.brightness).setColor(0.28F, 0.28F, 0.28F));
            }
        }
    }


    @Override
    public int nextEventDelay() {
        return 100;
    }

    @Override
    public void writeToNbt(class_2487 nbt) {
    }


    @Override
    public void readFromNbt(class_2487 nbt) {
    }


    public boolean transitionOut(BackroomsLevel.CrossDimensionTeleport crossDimensionTeleport) {
        if (!crossDimensionTeleport.world().method_8608() && !crossDimensionTeleport.playerComponent().isTeleporting()) {
            SPBRevamped.sendLevelTransitionLightsOutPacket((class_3222) crossDimensionTeleport.playerComponent().player, 80);
        }

        return crossDimensionTeleport.playerComponent().player.method_24828();
    }

    @Override
    public void transitionIn(BackroomsLevel.CrossDimensionTeleport crossDimensionTeleport) {
        if (!crossDimensionTeleport.world().method_8608()) {
            class_3222 player = (class_3222) crossDimensionTeleport.playerComponent().player;

            class_243 spawn = this.getSpawnPos();
            float yaw = -90;
            float pitch = -50;
            player.method_14251((class_3218) crossDimensionTeleport.world(), spawn.field_1352, spawn.field_1351, spawn.field_1350, yaw, pitch);

            Level207AmbienceEvent ambienceEvent = new Level207AmbienceEvent();
            ambienceEvent.init(crossDimensionTeleport.world());
            if (!events.contains(Level207AmbienceEvent.class)) {
                this.events.add(Level207AmbienceEvent::new);
            }

        }
    }

    @Override
    public int getTransitionDuration() {
        return 30;
    }
}
