package net.dark.spv_addon.world.levels.custom;

import com.sp.compat.modmenu.ConfigStuff;
import com.sp.mixininterfaces.NewServerProperties;
import com.sp.world.levels.BackroomsLevel;
import com.sp.world.levels.custom.Level2BackroomsLevel;
import net.dark.spv_addon.init.BackroomsLevels;
import net.dark.spv_addon.world.generation.ikea.LevelIKEAChunkGenerator;
import net.dark.spv_addon.world.levels.custom.events.HaHvavCustomEvent;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import java.util.ArrayList;
import java.util.List;

public class LevelIKEA extends BackroomsLevel {
    public LevelIKEA() {

        super("level_ikea", LevelIKEAChunkGenerator.field_24746, new class_243(16, 2, 16), BackroomsLevels.LEVEL_IKEA_WORLD_KEY, "spv_addon");

        com.sp.init.BackroomsLevels.LEVEL2_BACKROOMS_LEVEL.unregisterTransition("level2 -> poolrooms");

        com.sp.init.BackroomsLevels.LEVEL2_BACKROOMS_LEVEL.registerTransition((world, playerComponent, from) -> {
            List<BackroomsLevel.CrossDimensionTeleport> playerList = new ArrayList<>();
            int exitRadius = ConfigStuff.exitSpawnRadius;
            if (world.method_8503() != null && world.method_8503().method_3816()) {
                exitRadius = ((NewServerProperties) ((class_3176) world.method_8503()).method_16705()).getExitSpawnRadius();
            }

            if (from instanceof Level2BackroomsLevel && Math.abs(playerComponent.player.method_19538().method_10215()) >= (double) exitRadius && playerComponent.player.method_37908().method_27983() == com.sp.init.BackroomsLevels.LEVEL2_WORLD_KEY) {
                playerList.add(new BackroomsLevel.CrossDimensionTeleport(playerComponent.player.method_37908(), playerComponent, this.getSpawnPos(), com.sp.init.BackroomsLevels.LEVEL2_BACKROOMS_LEVEL, BackroomsLevels.LEVEL207_BACKROOMS_LEVEL));
            }

            return playerList;
        }, "level2 -> level207");
    }

    @Override
    public void register() {
        events.add(HaHvavCustomEvent::new);

    }


    @Override
    public int nextEventDelay() {
        return 100;
    }

    @Override
    public BoolTextPair allowsTorch() {
        return new BoolTextPair(true, class_2561.method_43471("Flash.on"));
    }

    @Override
    public void writeToNbt(class_2487 nbt) {
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
    }

    @Override
    public boolean transitionOut(CrossDimensionTeleport teleport) {
        return false;
    }

    @Override
    public void transitionIn(CrossDimensionTeleport teleport) {

    }

    @Override
    public int getTransitionDuration() {
        return 30;
    }
}
