package net.dark.spv_addon.world.levels.custom;

import com.sp.compat.modmenu.ConfigStuff;
import com.sp.mixininterfaces.NewServerProperties;
import com.sp.world.levels.BackroomsLevel;
import net.dark.spv_addon.entities.custom.KittyEntity;
import net.dark.spv_addon.init.BackroomsLevels;
import net.dark.spv_addon.init.ModEntities;
import net.dark.spv_addon.world.events.levelkitty.KittyMeowEvent;
import net.dark.spv_addon.world.generation.kitty.KittyChunkGenerator;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import java.util.ArrayList;
import java.util.List;

public class LevelKittyBackroomsLevel extends BackroomsLevel {
    private static boolean kittySpawned = false;
    private final class_5819 random = class_5819.method_43047();

    public LevelKittyBackroomsLevel() {
        super("level_kitty", KittyChunkGenerator.field_24746, new class_243(21, 2, 13), BackroomsLevels.LEVEL_KITTY_WORLD_KEY, "spv_addon");

        this.registerTransition((world, playerComponent, from) -> {
            List<CrossDimensionTeleport> playerList = new ArrayList<>();
            int exitRadius = ConfigStuff.exitSpawnRadius;
            if (world.method_8503() != null && world.method_8503().method_3816()) {
                exitRadius = ((NewServerProperties) ((class_3176) world.method_8503()).method_16705()).getExitSpawnRadius();
            }

            if (from instanceof LevelKittyBackroomsLevel && Math.abs(playerComponent.player.method_19538().method_10215()) >= (double) exitRadius && playerComponent.player.method_37908().method_27983() == BackroomsLevels.LEVEL_KITTY_WORLD_KEY) {
                playerList.add(new BackroomsLevel.CrossDimensionTeleport(playerComponent.player.method_37908(), playerComponent, this.getSpawnPos(), BackroomsLevels.LEVEL_KITTY_BACKROOMS_LEVEL, com.sp.init.BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL));
            }

            return playerList;
        }, "kitty -> poolrooms");
    }

    public static void ensureSingleKitty(class_3218 world) {
        if (kittySpawned) return;

        class_2338 spawnPos = new class_2338(15, 2, 18);
        if (!world.method_22340(spawnPos)) return;

        KittyEntity kitty = new KittyEntity(ModEntities.KITTY, world);
        kitty.method_5725(spawnPos, 0.0F, 0.0F);
        world.method_8649(kitty);
        kittySpawned = true;

        System.out.println("Spawned kitty at " + spawnPos);
    }

    @Override
    public void register() {

        events.add(KittyMeowEvent::new);

        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_27983().equals(BackroomsLevels.LEVEL_KITTY_WORLD_KEY)) {
                ensureSingleKitty(world);
            }
        });
    }

    public void tick(net.minecraft.class_3218 world) {
        ensureSingleKitty(world);
    }

    @Override
    public int nextEventDelay() {
        return this.random.method_39332(100, 1000);
    }

    @Override
    public void writeToNbt(class_2487 nbt) {
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
    }

    @Override
    public boolean transitionOut(BackroomsLevel.CrossDimensionTeleport crossDimensionTeleport) {
        return true;
    }

    @Override
    public void transitionIn(CrossDimensionTeleport teleport) {
        teleport.playerComponent().loadPlayerSavedInventory();
    }

    @Override
    public int getTransitionDuration() {
        return 10;
    }

}
