package net.dark.spv_addon.world.levels.custom;

import com.sp.entity.custom.SmilerEntity;
import com.sp.init.ModEntities;
import com.sp.world.levels.BackroomsLevel;
import net.dark.spv_addon.init.BackroomsLevels;
import net.dark.spv_addon.world.generation.run.RunChunkGenerator;
import net.dark.spv_addon.world.levels.custom.events.HaHvavCustomEvent;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class LevelRUNBackroomsLevel extends BackroomsLevel {
    private static final int SMILER_SPAWN_INTERVAL = 40;
    private final class_5819 random = class_5819.method_43047();
    private int smilerSpawnTick = 0;

    public LevelRUNBackroomsLevel() {
        super("run", RunChunkGenerator.field_24746, new class_243(-7.5, 1, 7.5), BackroomsLevels.LEVELRUN_WORLD_KEY, "spv_addon");
    }

    @Override
    public void register() {

        events.add(HaHvavCustomEvent::new);

    }

    public void tick(class_3218 world) {
        smilerSpawnTick++;
        if (smilerSpawnTick >= SMILER_SPAWN_INTERVAL) {
            smilerSpawnTick = 0;
            int count = 2 + world.field_9229.method_43048(3);
            for (int i = 0; i < count; i++) {
                double x = 10 + world.field_9229.method_43058() * (world.method_8621().method_11965() - 20);
                double y = 1;
                double z = 10 + world.field_9229.method_43058() * (world.method_8621().method_11965() - 20);
                SmilerEntity smiler = new SmilerEntity(ModEntities.SMILER_ENTITY, world);
                smiler.method_5808(x, y, z, world.field_9229.method_43057() * 360F, 0);
                world.method_8649(smiler);
            }
        }
    }

    @Override
    public int nextEventDelay() {
        return this.random.method_39332(2000, 3000);
    }

    @Override
    public void writeToNbt(class_2487 nbt) {
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
    }

    @Override
    public boolean transitionOut(CrossDimensionTeleport teleport) {
        return teleport.playerComponent().player.method_5715();
    }

    @Override
    public void transitionIn(CrossDimensionTeleport teleport) {
        teleport.playerComponent().loadPlayerSavedInventory();
    }

    @Override
    public int getTransitionDuration() {
        return 40;
    }
}
