/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.client;

import com.sp.cca_stuff.PlayerComponent;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import foundry.veil.api.client.render.deferred.light.Light;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dark.spv_addon.Additions.battery.BatteryManager;
import net.dark.spv_addon.cca.InitializeComponents;
import net.dark.spv_addon.cca.SanityComponent;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ClientFlashlightRendererAddon {
    private final class_310 client = class_310.method_1551();
    private final Map<UUID, List<AreaLight>> lightMap = new HashMap<UUID, List<AreaLight>>();

    public void tick(float tickDelta) {
        if (this.client.field_1687 == null) {
            return;
        }
        for (class_742 player : this.client.field_1687.method_18456()) {
            if (player.method_7325()) {
                this.forceOff(player);
                continue;
            }
            UUID uuid = player.method_5667();
            PlayerComponent comp = (PlayerComponent)com.sp.cca_stuff.InitializeComponents.PLAYER.get((Object)player);
            boolean isOn = comp.isFlashLightOn();
            int sanity = ((SanityComponent)InitializeComponents.SANITY.get((Object)player)).getSanityLevel();
            int battery = BatteryManager.getBattery(uuid);
            if (battery <= 0) {
                if (isOn) {
                    comp.setFlashLightOn(false);
                }
                this.forceOff(player);
                continue;
            }
            if (sanity <= 20) {
                if (this.client.field_1687.method_8409().method_43057() > 0.135f) {
                    if (!comp.isFlashLightOn()) {
                        comp.setFlashLightOn(true);
                    }
                    this.updateLight(player, tickDelta);
                    continue;
                }
                for (int i = 0; i < 5; ++i) {
                    boolean shouldBeOn = this.client.field_1687.method_8409().method_43056();
                    comp.setFlashLightOn(shouldBeOn);
                    if (shouldBeOn) {
                        this.updateLight(player, tickDelta);
                        continue;
                    }
                    this.removeLights(player);
                }
                continue;
            }
            if (sanity <= 0) {
                if (!comp.shouldGlitch()) {
                    comp.setShouldGlitch(true);
                    comp.justChanged();
                    if (!comp.shouldInflictGlitchDamage) {
                        comp.shouldInflictGlitchDamage = true;
                    }
                }
            } else if (comp.shouldGlitch()) {
                comp.setShouldGlitch(false);
                comp.justChanged();
                comp.shouldInflictGlitchDamage = false;
            }
            if (isOn) {
                this.updateLight(player, tickDelta);
                continue;
            }
            this.removeLights(player);
        }
    }

    private void updateLight(class_742 player, float tickDelta) {
        UUID uuid = player.method_5667();
        class_243 pos = player.method_5836(tickDelta);
        Quaternionf rot = new Quaternionf().rotateXYZ((float)(-Math.toRadians(player.method_5695(tickDelta))), (float)Math.toRadians(player.method_5705(tickDelta)), 0.0f);
        List lights = this.lightMap.computeIfAbsent(uuid, id -> {
            AreaLight l1 = new AreaLight().setBrightness(1.0f).setDistance(25.0f).setSize(0.0, 0.0).setPosition(pos.field_1352, pos.field_1351, pos.field_1350).setOrientation((Quaternionfc)rot);
            AreaLight l2 = new AreaLight().setBrightness(1.0f).setDistance(25.0f).setAngle(0.25f).setSize(0.0, 0.0).setPosition(pos.field_1352, pos.field_1351, pos.field_1350).setOrientation((Quaternionfc)rot);
            return Arrays.asList(l1, l2);
        });
        for (AreaLight light : lights) {
            light.setPosition(pos.field_1352, pos.field_1351, pos.field_1350);
            light.getOrientation().slerp((Quaternionfc)rot, 0.7f * this.client.method_1534());
        }
    }

    private void forceOff(class_742 player) {
        PlayerComponent comp = (PlayerComponent)com.sp.cca_stuff.InitializeComponents.PLAYER.get((Object)player);
        if (comp.isFlashLightOn()) {
            comp.setFlashLightOn(false);
        }
        this.removeLights(player);
    }

    private void removeLights(class_742 player) {
        UUID uuid = player.method_5667();
        List<AreaLight> lights = this.lightMap.remove(uuid);
        if (lights != null) {
            for (AreaLight light : lights) {
                VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer().removeLight((Light)light);
            }
        }
    }

    public void updateBattery(class_1657 player, int newBatteryValue) {
        UUID uuid = player.method_5667();
        int battery = BatteryManager.getBattery(uuid);
        if (battery != newBatteryValue) {
            System.out.println("Battery at " + battery + "% for " + player.method_5477().getString());
            player.method_7353((class_2561)class_2561.method_43470((String)("Battery at " + battery + "%")), true);
        }
    }
}

