/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class CustomDeathScreen
extends class_437 {
    private static final class_2960 BACKGROUND = new class_2960("spv_addon", "textures/gui/death_full.png");
    private static final class_2960 SCANLINES = new class_2960("spv_addon", "textures/gui/scanlines.png");
    private final String playerName;
    private int ticksElapsed = 0;
    private int glitchTicks = 0;
    private boolean isGlitching = false;
    private class_1011 staticImage = null;
    private class_1043 staticTexture = null;
    private final class_2960 dynamicStaticId = new class_2960("spv_addon", "dynamic_static");

    public CustomDeathScreen(String playerName) {
        super((class_2561)class_2561.method_43473());
        this.playerName = playerName;
    }

    public void method_25393() {
        if (!this.isGlitching) {
            ++this.ticksElapsed;
            if (this.ticksElapsed >= 200) {
                this.startGlitch();
            }
        } else {
            ++this.glitchTicks;
            if (this.glitchTicks >= 16) {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 != null) {
                    mc.field_1724.method_7331();
                }
                mc.method_1507(null);
                this.closeStaticImage();
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void updateStaticTexture(int w, int h) {
        if (this.staticImage == null || this.staticImage.method_4307() != w || this.staticImage.method_4323() != h) {
            this.closeStaticImage();
            this.staticImage = new class_1011(w, h, false);
            this.staticTexture = new class_1043(this.staticImage);
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int val = this.isGlitching ? (int)(Math.random() * 255.0) : (int)(Math.random() * 192.0 + 32.0);
                int color = 0xFF000000 | val << 16 | val << 8 | val;
                this.staticImage.method_4305(x, y, color);
            }
        }
        this.staticTexture.method_4524();
        class_310.method_1551().method_1531().method_4616(this.dynamicStaticId, (class_1044)this.staticTexture);
    }

    private void closeStaticImage() {
        if (this.staticImage != null) {
            this.staticImage.close();
        }
        this.staticImage = null;
        this.staticTexture = null;
    }

    private void startGlitch() {
        this.isGlitching = true;
        this.glitchTicks = 0;
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_310 mc = class_310.method_1551();
        int w = mc.method_22683().method_4486();
        int h = mc.method_22683().method_4502();
        RenderSystem.enableBlend();
        ctx.method_25290(BACKGROUND, 0, 0, 0.0f, 0.0f, w, h, w, h);
        RenderSystem.disableBlend();
        Objects.requireNonNull(mc.field_1772);
        int fontHeight = 9 + 8;
        int fontScale = 2;
        String line1 = this.playerName + " was";
        String line2 = "Never Found";
        int color = 0xFFFFFF;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)w / 2.0f, (float)h / 2.0f - (float)fontHeight, 0.0f);
        ctx.method_51448().method_22905((float)fontScale, (float)fontScale, 1.0f);
        int x1 = -mc.field_1772.method_1727(line1) / 2;
        int y1 = 0;
        ctx.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)line1), x1, y1, color, false);
        int x2 = -mc.field_1772.method_1727(line2) / 2;
        int y2 = (fontHeight + 2) / fontScale;
        ctx.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)line2), x2, y2, color, false);
        ctx.method_51448().method_22909();
        float frac = Math.min((float)this.ticksElapsed / 200.0f, 1.0f);
        float flicker = (float)(Math.sin((double)this.ticksElapsed * 0.6 + Math.random()) * 0.15 + 0.85);
        float alpha = this.isGlitching ? (float)(Math.random() * 0.7 + (double)0.3f) : frac * flicker;
        this.updateStaticTexture(w, h);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        ctx.method_25290(this.dynamicStaticId, 0, 0, 0.0f, 0.0f, w, h, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.1f * alpha));
        ctx.method_25290(SCANLINES, 0, 0, 0.0f, 0.0f, w, h, w, h);
        if (this.isGlitching && this.glitchTicks % 4 == 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
            ctx.method_25294(0, 0, w, h, -1711276033);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void method_25419() {
        super.method_25419();
        this.closeStaticImage();
    }
}

