/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.entities.ai.goals;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.dark.spv_addon.entities.custom.BellWalkerEntity;
import net.dark.spv_addon.init.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_5134;

public class AggroNearestPlayerGoal
extends class_1352 {
    private final BellWalkerEntity mob;
    private final double maxRange;
    private final double aggroSpeed;
    private double originalSpeed;
    private int soundCooldown;
    private class_1657 lastTarget;
    private static final int MIN_SOUND_DELAY = 5;
    private static final int MAX_SOUND_DELAY = 40;

    public AggroNearestPlayerGoal(BellWalkerEntity mob, double maxRange, double aggroSpeed) {
        this.mob = mob;
        this.maxRange = maxRange;
        this.aggroSpeed = aggroSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public AggroNearestPlayerGoal(BellWalkerEntity mob, double maxRange) {
        this(mob, maxRange, 0.6);
    }

    public boolean method_6264() {
        List<class_1657> candidates = this.mob.method_37908().method_18456().stream().filter(p -> this.mob.method_6017() >= 2.0f).filter(p -> p.method_5858((class_1297)this.mob) <= this.maxRange * this.maxRange).toList();
        if (candidates.isEmpty()) {
            return false;
        }
        class_1657 nearest = candidates.stream().min(Comparator.comparingDouble(p -> p.method_5858((class_1297)this.mob))).orElse(null);
        this.mob.method_5980((class_1309)nearest);
        this.lastTarget = nearest;
        return nearest != null;
    }

    public void method_6269() {
        if (this.lastTarget == null) {
            return;
        }
        class_1324 attr = this.mob.method_5996(class_5134.field_23719);
        if (attr != null) {
            this.originalSpeed = attr.method_6201();
            attr.method_6192(this.aggroSpeed);
        }
        double distSq = this.lastTarget.method_5858((class_1297)this.mob);
        this.soundCooldown = this.calculateSoundDelay(distSq);
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target instanceof class_1657 && --this.soundCooldown <= 0) {
            this.mob.method_5783(ModSounds.BELLWALKER_BELL, 1.0f, 1.0f);
            this.soundCooldown = this.calculateSoundDelay(target.method_5858((class_1297)this.mob));
        }
    }

    private int calculateSoundDelay(double squaredDistance) {
        double distance = Math.sqrt(squaredDistance);
        double ratio = Math.min(distance / this.maxRange, 1.0);
        return (int)(5.0 + 35.0 * ratio);
    }

    public boolean method_6266() {
        class_1309 target = this.mob.method_5968();
        return target instanceof class_1657 && target.method_5805() && this.mob.method_6017() >= 2.0f;
    }

    public void method_6270() {
        class_1324 attr = this.mob.method_5996(class_5134.field_23719);
        if (attr != null) {
            attr.method_6192(this.originalSpeed);
        }
        this.lastTarget = null;
    }
}

