/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.entities.ik.util;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class MathUtil {
    public static class_243 toVec3(Vector3d vector3d) {
        return new class_243(vector3d.x(), vector3d.y(), vector3d.z());
    }

    public static Vector3d toVector3d(class_243 vector3d) {
        return new Vector3d(vector3d.field_1352, vector3d.field_1351, vector3d.field_1350);
    }

    public static class_243 getFlatRotationVector(class_1297 entity) {
        return MathUtil.getFlatRotationVector(entity.method_43078());
    }

    public static class_243 getFlatRotationVector(double yRot) {
        float f = 0.0f;
        float g = (float)(-yRot * 0.01745329238474369);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j)).method_1029();
    }

    public static class_243 getOpposingFlatRotationVector(class_1297 entity) {
        return MathUtil.getFlatRotationVector(entity.method_43078() - 180.0f);
    }

    public static class_243 getRotation(class_243 base, class_243 target) {
        float dz = (float)(target.field_1350 - base.field_1350);
        float dx = (float)(target.field_1352 - base.field_1352);
        float dy = (float)(target.field_1351 - base.field_1351);
        float yaw = (float)class_3532.method_15349((double)dz, (double)dx);
        float pitch = (float)class_3532.method_15349((double)Math.sqrt(dz * dz + dx * dx), (double)dy);
        return MathUtil.wrapAngles(new class_243((double)yaw, (double)pitch, 0.0));
    }

    private static class_243 wrapAngles(class_243 vec3d) {
        double x;
        double y = vec3d.field_1351;
        double z = vec3d.field_1350;
        for (x = vec3d.field_1352; x > Math.PI; x -= Math.PI * 2) {
        }
        while (x < -Math.PI) {
            x += Math.PI * 2;
        }
        while (y > Math.PI) {
            y -= Math.PI * 2;
        }
        while (y < -Math.PI) {
            y += Math.PI * 2;
        }
        while (z > Math.PI) {
            z -= Math.PI * 2;
        }
        while (z < -Math.PI) {
            z += Math.PI * 2;
        }
        return new class_243(x, y, z);
    }

    public static class_243 dividePos(class_243 v1, double divide) {
        return new class_243(v1.field_1352 / divide, v1.field_1351 / divide, v1.field_1350 / divide);
    }

    public static Quaternionf quatFromRotationXYZ(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        return new Quaternionf().rotationXYZ(x, y, z);
    }

    public static class_243 getAverage(List<class_243> points) {
        class_243 sum = class_243.field_1353;
        for (class_243 point : points) {
            sum = sum.method_1019(point);
        }
        return MathUtil.dividePos(sum, points.size());
    }

    public static class_243 getAverage(class_243 ... points) {
        return MathUtil.getAverage(Arrays.stream(points).toList());
    }

    public static double calculateAngle(class_243 A, class_243 B, class_243 C) {
        double a = C.method_1022(B);
        double b = A.method_1022(C);
        double c = A.method_1022(B);
        double cosA = (b * b + c * c - a * a) / (2.0 * b * c);
        return Math.acos(cosA);
    }

    public static class_243 rotatePointOnAPlaneAround(class_243 RotatedPoint, class_243 stationaryPoint, double angle, class_243 rotationAxis) {
        Vector3d A = new Vector3d(stationaryPoint.field_1352, stationaryPoint.field_1351, stationaryPoint.field_1350);
        Vector3d C = new Vector3d(RotatedPoint.field_1352, RotatedPoint.field_1351, RotatedPoint.field_1350);
        Quaterniond rotation = new Quaterniond().rotateAxis(Math.toRadians(angle), rotationAxis.field_1352, rotationAxis.field_1351, rotationAxis.field_1350);
        Vector3d rotatedV1 = new Vector3d();
        rotation.transform((Vector3dc)new Vector3d((Vector3dc)C).sub((Vector3dc)A), rotatedV1);
        return new class_243(new Vector3d((Vector3dc)rotatedV1).add((Vector3dc)A).x(), new Vector3d((Vector3dc)rotatedV1).add((Vector3dc)A).y(), new Vector3d((Vector3dc)rotatedV1).add((Vector3dc)A).z());
    }

    public static class_243 getUpDirection(class_243 v1, class_243 v2, class_243 v3) {
        class_243 AB = v2.method_1020(v1);
        class_243 AC = v3.method_1020(v1);
        class_243 axis = AB.method_1036(AC).method_1029();
        return axis;
    }

    public static class_243 getClosestNormalRelativeToEntity(class_243 basePoint, class_243 v2, class_243 v3, class_1297 entity) {
        class_243 referencePoint = MathUtil.getFlatRotationVector(entity.method_43078() + 90.0f);
        class_243 normal = MathUtil.getNormalClosestTo(basePoint, v2, v3, basePoint.method_1019(referencePoint.method_1021(100.0)));
        return normal;
    }

    public static class_243 getNormalClosestTo(class_243 basePoint, class_243 v2, class_243 v3, class_243 orientationPoint) {
        class_243 normal = MathUtil.getUpDirection(basePoint, v2, v3);
        class_243 oppositeNormal = normal.method_22882();
        return basePoint.method_1019(normal).method_1025(orientationPoint) < basePoint.method_1019(oppositeNormal).method_1025(orientationPoint) ? normal : oppositeNormal;
    }

    public static class_243 lerpVec3(int step, class_243 OldPos, class_243 newPos) {
        double d = 1.0 / (double)step;
        double newX = class_3532.method_16436((double)d, (double)OldPos.field_1352, (double)newPos.field_1352);
        double newY = class_3532.method_16436((double)d, (double)OldPos.field_1351, (double)newPos.field_1351);
        double newZ = class_3532.method_16436((double)d, (double)OldPos.field_1350, (double)newPos.field_1350);
        return new class_243(newX, newY, newZ);
    }

    public static class_243 lerpVector3d(int step, Vector3d OldPos, Vector3d newPos) {
        return MathUtil.lerpVec3(step, MathUtil.toVec3(OldPos), MathUtil.toVec3(newPos));
    }

    public static class_243 convertToFlatVector(class_243 v1) {
        return new class_243((double)((float)v1.field_1352), 0.0, (double)((float)v1.field_1350));
    }
}

