/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.init.grass;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sp.compat.modmenu.ConfigStuff;
import com.sp.mixininterfaces.RenderIndirectExtension;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.nio.ByteBuffer;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;

public class GrassRenderer {
    class_291 vertexBuffer = new class_291(class_291.class_8555.field_44793);
    private static final class_2960 shaderPath = new class_2960("spv_addon", "grass/grass");
    private static final class_2960 windTexture = new class_2960("spv_addon", "textures/environment/puddle_noise.png");
    private static final class_2960 computeShaderPath = new class_2960("spv_addon", "grass/compute/positions");
    private final int positionsVbo;
    private final int indirectVbo;
    private int lastGrassCount;
    private int lastMeshResolution;
    private ByteBuffer cmd;
    public static final class_293 POSITION_NORMAL = new class_293(ImmutableMap.of((Object)"Position", (Object)class_290.field_1587, (Object)"Normal", (Object)class_290.field_1579));

    private float getGrassHeight() {
        return 0.5f;
    }

    public GrassRenderer() {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, POSITION_NORMAL);
        this.createGrassModel(bufferBuilder);
        class_287.class_7433 builtBuffer = bufferBuilder.method_1326();
        this.vertexBuffer.method_1353();
        this.vertexBuffer.method_1352(builtBuffer);
        class_291.method_1354();
        this.positionsVbo = GL15C.glGenBuffers();
        this.indirectVbo = GL15C.glGenBuffers();
        this.updateBuffers(true);
    }

    public void render() {
        AdvancedFbo fbo = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.OPAQUE);
        if (fbo != null) {
            fbo.bind(false);
            if (ConfigStuff.grassQuality.getCount() != this.lastGrassCount || ConfigStuff.grassQuality.getResolution() != this.lastMeshResolution) {
                if (this.vertexBuffer != null) {
                    this.vertexBuffer.close();
                }
                this.vertexBuffer = new class_291(class_291.class_8555.field_44793);
                class_289 tessellator = class_289.method_1348();
                class_287 bufferBuilder = tessellator.method_1349();
                bufferBuilder.method_1328(class_293.class_5596.field_27382, POSITION_NORMAL);
                this.createGrassModel(bufferBuilder);
                this.vertexBuffer.method_1353();
                this.vertexBuffer.method_1352(bufferBuilder.method_1326());
                class_291.method_1354();
            }
            this.updateBuffers(false);
            this.computeGrassPositions();
            ShaderProgram shader = VeilRenderSystem.setShader((class_2960)shaderPath);
            if (shader != null) {
                shader.setFloat((CharSequence)"GameTime", RenderSystem.getShaderGameTime());
                shader.setInt((CharSequence)"NumOfInstances", class_3532.method_15375((float)class_3532.method_15355((float)ConfigStuff.grassQuality.getCount())));
                shader.setFloat((CharSequence)"grassHeight", this.getGrassHeight());
                shader.setFloat((CharSequence)"density", ConfigStuff.grassQuality.getDensity());
                RenderSystem.setShaderTexture((int)0, (class_2960)windTexture);
                shader.addSampler((CharSequence)"WindNoise", RenderSystem.getShaderTexture((int)0));
                shader.applyShaderSamplers(0);
                this.vertexBuffer.method_1353();
                GL15C.glBindBuffer((int)36671, (int)this.indirectVbo);
                GL42C.glBindBufferBase((int)37074, (int)0, (int)this.positionsVbo);
                shader.bind();
                ((RenderIndirectExtension)this.vertexBuffer).spb_revamped_1_20_1$drawIndirect();
                ShaderProgram.unbind();
                shader.clearSamplers();
                GL42C.glBindBufferBase((int)37074, (int)0, (int)0);
                GL15C.glBindBuffer((int)36671, (int)0);
                class_291.method_1354();
                AdvancedFbo.unbind();
            }
        }
    }

    private void updateBuffers(boolean init) {
        boolean resolutionChange;
        int currentGrassCount = ConfigStuff.grassQuality.getCount();
        int currentMeshResolution = ConfigStuff.grassQuality.getResolution();
        boolean countChange = currentGrassCount != this.lastGrassCount;
        boolean bl = resolutionChange = currentMeshResolution != this.lastMeshResolution;
        if (countChange) {
            GL15C.glBindBuffer((int)37074, (int)this.positionsVbo);
            GL42C.glBufferData((int)37074, (long)(4L * (long)currentGrassCount * 4L), (int)35048);
            GL15C.glBindBuffer((int)37074, (int)0);
        }
        GL15C.glBindBuffer((int)36671, (int)this.indirectVbo);
        GL42C.glBufferData((int)36671, (long)20L, (int)35044);
        this.cmd = GL42C.glMapBufferRange((int)36671, (long)0L, (long)20L, (int)42);
        if (this.cmd != null) {
            this.cmd.clear();
            this.cmd.putInt(VeilRenderSystem.getIndexCount((class_291)this.vertexBuffer));
            this.cmd.putInt(0);
            this.cmd.putInt(0);
            this.cmd.putInt(0);
            this.cmd.putInt(0);
            this.cmd.flip();
        }
        GL42C.glUnmapBuffer((int)36671);
        GL15C.glBindBuffer((int)36671, (int)0);
        if (countChange) {
            this.lastGrassCount = currentGrassCount;
        }
        if (resolutionChange) {
            this.lastMeshResolution = currentMeshResolution;
        }
    }

    private void computeGrassPositions() {
        ShaderProgram shader = VeilRenderSystem.setShader((class_2960)computeShaderPath);
        if (shader != null) {
            if (shader.isCompute()) {
                GL42C.glBindBufferBase((int)37074, (int)0, (int)this.positionsVbo);
                GL42C.glBindBufferBase((int)37074, (int)1, (int)this.indirectVbo);
                int numOfInst = class_3532.method_15375((float)class_3532.method_15355((float)ConfigStuff.grassQuality.getCount()));
                shader.setInt((CharSequence)"NumOfInstances", numOfInst);
                shader.setFloat((CharSequence)"density", ConfigStuff.grassQuality.getDensity());
                float maxDist = (float)numOfInst / (ConfigStuff.grassQuality.getDensity() * 1.85f);
                shader.setFloat((CharSequence)"maxDist", maxDist);
                Vector4fc[] planes = VeilRenderer.getCullingFrustum().getPlanes();
                float[] values = new float[4 * planes.length];
                for (int i = 0; i < planes.length; ++i) {
                    Vector4fc plane = planes[i];
                    values[i * 4] = plane.x();
                    values[i * 4 + 1] = plane.y();
                    values[i * 4 + 2] = plane.z();
                    values[i * 4 + 3] = plane.w();
                }
                shader.setFloats((CharSequence)"FrustumPlanes", values);
                shader.bind();
                int grass = class_3532.method_15375((float)(class_3532.method_15355((float)ConfigStuff.grassQuality.getCount()) / 8.0f));
                int x = Math.min(grass, VeilRenderSystem.maxComputeWorkGroupCountX());
                int y = Math.min(grass, VeilRenderSystem.maxComputeWorkGroupCountY());
                GL43C.glDispatchCompute((int)x, (int)y, (int)1);
                GL42C.glMemoryBarrier((int)-1);
                ShaderProgram.unbind();
                GL42C.glBindBufferBase((int)37074, (int)0, (int)0);
                GL42C.glBindBufferBase((int)37074, (int)1, (int)0);
            }
            ShaderProgram.unbind();
        }
    }

    private void createGrassModel(class_287 bufferBuilder) {
        int segments = ConfigStuff.grassQuality.getResolution();
        float xStep = 0.1f / (float)segments;
        for (int i = 0; i < segments; ++i) {
            bufferBuilder.method_22912(0.6 - (double)(xStep * (float)(i + 1)), (double)(this.getGrassHeight() / (float)segments * (float)(i + 1)), 0.0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912(0.4 + (double)(xStep * (float)(i + 1)), (double)(this.getGrassHeight() / (float)segments * (float)(i + 1)), 0.0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912(0.4 + (double)(xStep * (float)i), (double)(this.getGrassHeight() / (float)segments * (float)i), 0.0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912(0.6 - (double)(xStep * (float)i), (double)(this.getGrassHeight() / (float)segments * (float)i), 0.0).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            bufferBuilder.method_22912(0.6 - (double)(xStep * (float)i), (double)(this.getGrassHeight() / (float)segments * (float)i), 0.0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
            bufferBuilder.method_22912(0.4 + (double)(xStep * (float)i), (double)(this.getGrassHeight() / (float)segments * (float)i), 0.0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
            bufferBuilder.method_22912(0.4 + (double)(xStep * (float)(i + 1)), (double)(this.getGrassHeight() / (float)segments * (float)(i + 1)), 0.0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
            bufferBuilder.method_22912(0.6 - (double)(xStep * (float)(i + 1)), (double)(this.getGrassHeight() / (float)segments * (float)(i + 1)), 0.0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        }
    }

    public void close() {
        GL42C.glDeleteBuffers((int)this.positionsVbo);
        GL42C.glDeleteBuffers((int)this.indirectVbo);
        GL42C.glUnmapBuffer((int)36671);
        this.cmd.clear();
        this.cmd = null;
    }
}

