/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.voicechat;

import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.PlayerDisconnectedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStoppedEvent;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;

public class SpvAddonVoicechatPlugin
implements VoicechatPlugin {
    public static VoicechatServerApi voicechatApi;
    private final ConcurrentHashMap<UUID, OpusDecoder> decoders = new ConcurrentHashMap();
    public static final Set<UUID> justMadeNoise;

    public String getPluginId() {
        return "spv_addon";
    }

    public void initialize(VoicechatApi api) {
        this.decoders.clear();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophonePacket);
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStart);
        registration.registerEvent(VoicechatServerStoppedEvent.class, this::onServerStop);
        registration.registerEvent(PlayerDisconnectedEvent.class, this::onPlayerDisconnect);
    }

    private void onMicrophonePacket(MicrophonePacketEvent event) {
        Object playerObj;
        VoicechatConnection sender = event.getSenderConnection();
        if (sender != null && (playerObj = sender.getPlayer().getPlayer()) instanceof class_1657) {
            class_1657 player = (class_1657)playerObj;
            justMadeNoise.add(player.method_5667());
        }
    }

    private void onServerStart(VoicechatServerStartedEvent event) {
        voicechatApi = event.getVoicechat();
    }

    private void onServerStop(VoicechatServerStoppedEvent event) {
        this.decoders.forEach(this::removePlayerDecoder);
        this.decoders.clear();
        justMadeNoise.clear();
    }

    private void onPlayerDisconnect(PlayerDisconnectedEvent event) {
        UUID uuid = event.getPlayerUuid();
        this.removePlayerDecoder(uuid, this.decoders.get(uuid));
        justMadeNoise.remove(uuid);
    }

    private void removePlayerDecoder(UUID uuid, OpusDecoder decoder) {
        if (decoder != null) {
            try {
                decoder.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.decoders.remove(uuid);
    }

    public static boolean hasJustMadeNoise(UUID uuid) {
        return justMadeNoise.contains(uuid);
    }

    public static void resetNoiseEachTick(MinecraftServer server) {
        justMadeNoise.clear();
    }

    static {
        justMadeNoise = new ConcurrentSkipListSet<UUID>();
    }
}

