/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.world.generation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.server.MinecraftServer;

public class Level5ChunkGenerator
extends class_2794 {
    public static final Codec<Level5ChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(gen -> gen.biomeSource), (App)class_5284.field_24781.fieldOf("settings").forGetter(gen -> gen.settings)).apply((Applicative)instance, Level5ChunkGenerator::new));
    private final class_6880<class_5284> settings;
    private final class_1966 biomeSource;

    public Level5ChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
        super(biomeSource);
        this.biomeSource = biomeSource;
        this.settings = settings;
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return 0;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return null;
    }

    public int method_16398() {
        return 0;
    }

    public int method_33730() {
        return 0;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        return 0;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        return null;
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }

    public void generate(class_5281 world, class_2791 chunk) {
        int baseX = chunk.method_12004().method_8326();
        int baseZ = chunk.method_12004().method_8328();
        class_5819 random = class_5819.method_43047();
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return;
        }
        class_3485 templateManager = server.method_27727();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int gridSize = 3;
        int spacing = 20;
        int[][] occupied = new int[64][64];
        for (int gx = 0; gx < gridSize; ++gx) {
            for (int gz = 0; gz < gridSize; ++gz) {
                int z;
                int x;
                Level5RoomRegistry.RoomType type = switch (random.method_43048(5)) {
                    case 0 -> Level5RoomRegistry.RoomType.GUESTROOM;
                    case 1 -> Level5RoomRegistry.RoomType.MEGAROOM;
                    case 2 -> Level5RoomRegistry.RoomType.HALLWAY;
                    case 3 -> Level5RoomRegistry.RoomType.LOBBY;
                    default -> Level5RoomRegistry.RoomType.JUNCTION;
                };
                Level5RoomRegistry.RoomEntry room = Level5RoomRegistry.getRandomRoom(type, random);
                if (room == null) continue;
                int px = baseX + gx * spacing;
                int pz = baseZ + gz * spacing;
                boolean overlap = false;
                block8: for (x = px; x < px + room.sizeX(); ++x) {
                    for (z = pz; z < pz + room.sizeZ(); ++z) {
                        if (occupied[x % 64][z % 64] != 1) continue;
                        overlap = true;
                        continue block8;
                    }
                }
                if (overlap) continue;
                for (x = px; x < px + room.sizeX(); ++x) {
                    for (z = pz; z < pz + room.sizeZ(); ++z) {
                        occupied[x % 64][z % 64] = 1;
                    }
                }
                Optional opt = templateManager.method_15094(room.id());
                if (!opt.isPresent()) continue;
                ((class_3499)opt.get()).method_15172((class_5425)world, (class_2338)mutable.method_10103(px, 18, pz), (class_2338)mutable.method_10103(px, 18, pz), this.randomRotation(), random, 2);
            }
        }
        for (int rx = 0; rx < gridSize; ++rx) {
            for (int rz = 0; rz < gridSize; ++rz) {
                Level5RoomRegistry.RoomEntry roof = Level5RoomRegistry.getRandomRoom(Level5RoomRegistry.RoomType.ROOF, random);
                if (roof == null) continue;
                int px = baseX + rx * spacing;
                int pz = baseZ + rz * spacing;
                Optional opt = templateManager.method_15094(roof.id());
                if (!opt.isPresent()) continue;
                ((class_3499)opt.get()).method_15172((class_5425)world, (class_2338)mutable.method_10103(px, 32, pz), (class_2338)mutable.method_10103(px, 32, pz), this.randomRotation(), random, 16);
            }
        }
    }

    private void placeRoofs(class_5281 world, int x, int z, class_5819 random, class_3485 manager, class_2338.class_2339 pos) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                class_2960 id = new class_2960("spv_addon", "level5/roof1");
                class_3492 data = this.randomRotation();
                Optional template = manager.method_15094(id);
                int px = x + 8 * i;
                int pz = z + 8 * j;
                if (world.method_8320((class_2338)pos.method_10103(px, 32, pz)) != class_2246.field_10124.method_9564()) continue;
                template.ifPresent(struct -> struct.method_15172((class_5425)world, new class_2338(px, 32, pz), (class_2338)pos, data, random, 16));
            }
        }
    }

    private class_3492 defaultPlacement() {
        return new class_3492().method_15125(class_2415.field_11302).method_15123(class_2470.field_11467).method_15133(true);
    }

    private class_3492 randomRotation() {
        class_3492 data = new class_3492().method_15125(class_2415.field_11302).method_15133(true);
        data.method_15123(class_5819.method_43047().method_39332(1, 2) == 1 ? class_2470.field_11467 : class_2470.field_11463);
        return data;
    }

    public class Level5RoomRegistry {
        private static final List<RoomEntry> registeredRooms = new ArrayList<RoomEntry>();

        public static void register(RoomType type, class_2960 id, int sizeX, int sizeZ) {
            registeredRooms.add(new RoomEntry(type, id, sizeX, sizeZ));
        }

        public static List<RoomEntry> getRooms(RoomType type) {
            return registeredRooms.stream().filter(e -> e.type == type).toList();
        }

        public static RoomEntry getRandomRoom(RoomType type, class_5819 random) {
            List<RoomEntry> list = Level5RoomRegistry.getRooms(type);
            return list.isEmpty() ? null : list.get(random.method_43048(list.size()));
        }

        public record RoomEntry(RoomType type, class_2960 id, int sizeX, int sizeZ) {
        }

        public static enum RoomType {
            GUESTROOM,
            HALLWAY,
            JUNCTION,
            LOBBY,
            MEGAROOM,
            ROOF,
            STAIRS,
            STORAGE,
            TRAP;

        }
    }
}

