/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.world.generation.run;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sp.SPBRevampedClient;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.server.MinecraftServer;

public final class RunChunkGenerator
extends class_2794 {
    public static final Codec<RunChunkGenerator> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(g -> g.field_12761), (App)class_5284.field_24781.fieldOf("settings").forGetter(g -> g.settings)).apply((Applicative)inst, inst.stable(RunChunkGenerator::new)));
    private final class_6880<class_5284> settings;
    private final class_5819 random = class_5819.method_43047();
    private final int corridorLength;

    public RunChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
        super(biomeSource);
        SPBRevampedClient.setInBackrooms((boolean)true);
        this.settings = settings;
        this.corridorLength = this.random.method_39332(100, 500);
    }

    public int getCorridorLength() {
        return this.corridorLength;
    }

    public int getExitChunkIndex() {
        return (this.corridorLength - 1) / 16;
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        class_3492 placeData;
        class_2338.class_2339 basePos;
        class_2960 roomId;
        int cx = chunk.method_12004().field_9181;
        int cz = chunk.method_12004().field_9180;
        if (cz != 0) {
            SPBRevampedClient.setInBackrooms((boolean)false);
            return;
        }
        int exitChunk = (this.corridorLength - 1) / 16;
        if (cx == 0) {
            roomId = new class_2960("spv_addon", "run/entrance");
        } else if (cx == exitChunk) {
            roomId = new class_2960("spv_addon", "run/exit");
        } else if (cx < exitChunk) {
            int hallwayType = this.random.method_39332(1, 5);
            roomId = new class_2960("spv_addon", "run/hallway" + hallwayType);
        } else {
            return;
        }
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return;
        }
        class_3485 mgr = server.method_27727();
        Optional optTpl = mgr.method_15094(roomId);
        if (optTpl.isEmpty()) {
            return;
        }
        int bx = chunk.method_12004().method_8326();
        int bz = chunk.method_12004().method_8328();
        int yOffset = 0;
        class_3499 template = (class_3499)optTpl.get();
        for (class_3499.class_3501 blockInfo : template.method_16445(class_2338.field_10980, new class_3492(), class_2246.field_10028)) {
            if (!blockInfo.comp_1342().method_27852(class_2246.field_10028)) continue;
            yOffset = blockInfo.comp_1341().method_10264() + 1;
            break;
        }
        if (!template.method_15172((class_5425)world, (class_2338)(basePos = new class_2338.class_2339(bx, -yOffset, bz)), (class_2338)basePos, placeData = new class_3492().method_15125(class_2415.field_11302).method_15123(class_2470.field_11463).method_15133(true), this.random, 2)) {
            return;
        }
        class_2960 roofId = new class_2960("spv_addon", "run/run_roof1");
        Optional roofTpl = mgr.method_15094(roofId);
        if (roofTpl.isEmpty()) {
            return;
        }
        class_3492 roofData = new class_3492().method_15125(class_2415.field_11302).method_15123(class_2470.field_11463).method_15133(true);
        int roofY = 5;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int px = bx + 8 * i;
                int pz = bz + 8 * j;
                class_2338 roofPos = new class_2338(px, roofY, pz);
                ((class_3499)roofTpl.get()).method_15172((class_5425)world, roofPos, roofPos, roofData, this.random, 16);
            }
        }
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int method_16398() {
        return 0;
    }

    public int method_33730() {
        return 0;
    }

    public int method_12104() {
        return 256;
    }

    public int method_16397(int x, int z, class_2902.class_2903 type, class_5539 view, class_7138 noiseConfig) {
        return this.method_12104();
    }

    public class_4966 method_26261(int x, int z, class_5539 view, class_7138 noiseConfig) {
        class_2680[] states = new class_2680[this.method_12104()];
        for (int i = 0; i < states.length; ++i) {
            states[i] = class_2246.field_10124.method_9564();
        }
        return new class_4966(0, states);
    }

    public void method_12108(class_3233 region, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structAcc, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structAcc, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }
}

