/*
 * Decompiled with CFR 0.152.
 */
package net.dark.spv_addon.world.levels.custom;

import com.sp.SPBRevamped;
import com.sp.cca_stuff.InitializeComponents;
import com.sp.cca_stuff.PlayerComponent;
import com.sp.world.levels.BackroomsLevel;
import com.sp.world.levels.custom.Level1BackroomsLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.dark.spv_addon.init.BackroomsLevels;
import net.dark.spv_addon.world.events.level207.Level207AmbienceEvent;
import net.dark.spv_addon.world.events.level207.Level207BellWalkerEvent;
import net.dark.spv_addon.world.events.level207.Level207MoveTracker;
import net.dark.spv_addon.world.generation.level207.Level207ChunkGenerator;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5819;

public class Level207BackroomsLevel
extends BackroomsLevel {
    private final class_5819 random = class_5819.method_43047();
    private int STEPS_BEFORE_WARP = 300 + this.random.method_43048(701);
    private final Map<UUID, Integer> stepsWalked = new HashMap<UUID, Integer>();
    private static final int STEPS_BEFORE_BELLWALKER = 100;

    public Level207BackroomsLevel() {
        super("level207", Level207ChunkGenerator.CODEC, new class_243(7.0, 66.0, 7.0), BackroomsLevels.LEVEL207_WORLD_KEY, "spv_addon");
        this.registerTransition((world, playerComponent, from) -> {
            ArrayList<BackroomsLevel.CrossDimensionTeleport> playerList = new ArrayList<BackroomsLevel.CrossDimensionTeleport>();
            if (from instanceof Level1BackroomsLevel && playerComponent.player.method_19538().method_10214() <= 12.0 && playerComponent.player.method_24828()) {
                for (class_1657 player : playerComponent.player.method_37908().method_18456()) {
                    PlayerComponent otherPlayerComponent = (PlayerComponent)InitializeComponents.PLAYER.get((Object)player);
                    double playerY = player.method_19538().method_10214();
                    if (player.method_37908().method_27983() != BackroomsLevels.LEVEL207_WORLD_KEY || playerY != 60.0 || !player.method_24828()) continue;
                    playerList.add(new BackroomsLevel.CrossDimensionTeleport(player.method_37908(), otherPlayerComponent, this.calculateLevel2TeleportCoords(player, playerComponent.player.method_31476()), BackroomsLevels.LEVEL207_BACKROOMS_LEVEL, com.sp.init.BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL));
                }
            }
            return playerList;
        }, "level207 -> poolrooms");
    }

    private class_243 calculateLevel2TeleportCoords(class_1657 player, class_1923 chunkPos) {
        if (chunkPos.field_9181 == player.method_31476().field_9181 && chunkPos.field_9180 == player.method_31476().field_9180) {
            int chunkX = chunkPos.method_8326();
            int chunkZ = chunkPos.method_8328();
            double playerX = player.method_19538().field_1352;
            double playerZ = player.method_19538().field_1350;
            return new class_243(playerX - (double)chunkX - 1.0, player.method_19538().field_1351 + 8.0, playerZ - (double)chunkZ);
        }
        return this.getSpawnPos();
    }

    public void onPlayerMove(class_1657 player, class_243 oldPos, class_243 newPos) {
        if (!player.method_24828()) {
            return;
        }
        int steps = (int)oldPos.method_1022(newPos);
        if (steps <= 0) {
            return;
        }
        UUID uuid = player.method_5667();
        this.stepsWalked.put(uuid, this.stepsWalked.getOrDefault(uuid, 0) + steps);
        if (this.stepsWalked.get(uuid) >= this.STEPS_BEFORE_WARP) {
            this.stepsWalked.put(uuid, 0);
            PlayerComponent pc = (PlayerComponent)InitializeComponents.PLAYER.get((Object)player);
            pc.setShouldNoClip(true);
            pc.sync();
            BackroomsLevel.CrossDimensionTeleport teleport = new BackroomsLevel.CrossDimensionTeleport(player.method_37908(), pc, this.getSpawnPos(), BackroomsLevels.LEVEL207_BACKROOMS_LEVEL, com.sp.init.BackroomsLevels.POOLROOMS_BACKROOMS_LEVEL);
            this.transitionOut(teleport);
            player.method_5682().execute(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pc.setShouldNoClip(false);
                pc.sync();
            });
            this.STEPS_BEFORE_WARP = 300 + this.random.method_43048(701);
        }
    }

    public void register() {
        Level207MoveTracker.register(this);
        this.events.add(Level207BellWalkerEvent::new);
    }

    public int nextEventDelay() {
        return 100;
    }

    public void writeToNbt(class_2487 nbt) {
    }

    public void readFromNbt(class_2487 nbt) {
    }

    public boolean transitionOut(BackroomsLevel.CrossDimensionTeleport crossDimensionTeleport) {
        if (!crossDimensionTeleport.world().method_8608() && !crossDimensionTeleport.playerComponent().isTeleporting()) {
            SPBRevamped.sendLevelTransitionLightsOutPacket((class_3222)((class_3222)crossDimensionTeleport.playerComponent().player), (int)80);
        }
        return crossDimensionTeleport.playerComponent().player.method_24828();
    }

    public void transitionIn(BackroomsLevel.CrossDimensionTeleport crossDimensionTeleport) {
        if (!crossDimensionTeleport.world().method_8608()) {
            Level207AmbienceEvent ambienceEvent = new Level207AmbienceEvent();
            ambienceEvent.init(crossDimensionTeleport.world());
        }
    }

    public int getTransitionDuration() {
        return 30;
    }
}

