/*
 * Decompiled with CFR 0.152.
 */
package wf.minecolab.wauf;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvertisementHandler {
    private final JavaPlugin plugin;
    private final String adsUrl;
    private String serverLink;
    private String discordLink;

    public AdvertisementHandler(JavaPlugin plugin, String adsUrl) {
        this.plugin = plugin;
        this.adsUrl = adsUrl;
    }

    public void loadAdsSync() throws Exception {
        String line;
        URL url = new URL(this.adsUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("HTTP " + conn.getResponseCode());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        JsonObject json = JsonParser.parseString((String)sb.toString()).getAsJsonObject();
        if (json.has("minecraft_server")) {
            this.serverLink = json.get("minecraft_server").getAsString();
        }
        if (json.has("discord_channel")) {
            this.discordLink = json.get("discord_channel").getAsString();
        }
    }

    public String getServerLink() {
        return this.serverLink;
    }

    public String getDiscordLink() {
        return this.discordLink;
    }
}

