/*
 * Decompiled with CFR 0.152.
 */
package wf.minecolab.wauf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import wf.minecolab.wauf.AdvertisementHandler;
import wf.minecolab.wauf.Metrics;

public class Wauf
extends JavaPlugin
implements Listener {
    private static final String PERM_USE = "wauf.use";
    private static final String PERM_NOTIFY = "wauf.notify";
    private static final String PERM_EXCLUDE = "wauf.exclude";
    private FileConfiguration ipDataConfig;
    private File ipDataFile;

    public void onEnable() {
        String adsRawUrl = "https://raw.githubusercontent.com/josebtan/FishingPot/main/ads.json";
        AdvertisementHandler adHandler = new AdvertisementHandler(this, adsRawUrl);
        String serverLink = null;
        String discordLink = null;
        try {
            adHandler.loadAdsSync();
            serverLink = adHandler.getServerLink();
            discordLink = adHandler.getDiscordLink();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        String version = this.getDescription().getVersion();
        List authors = this.getDescription().getAuthors();
        String author = authors.isEmpty() ? "Unknown" : (String)authors.get(0);
        this.ipDataFile = new File(this.getDataFolder(), "ipdata.yml");
        this.ipDataConfig = YamlConfiguration.loadConfiguration((File)this.ipDataFile);
        int pluginId = 26713;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        StringBuilder info = new StringBuilder("\n").append("         +====================+\n").append("         |        WAUF        |\n").append("         +====================+\n").append(String.format("  Plugin version: %s   Author: %s%n", version, author));
        if (serverLink != null) {
            info.append(String.format("  Minecraft Server: %s%n", serverLink));
        }
        if (discordLink != null) {
            info.append(String.format("  Discord: %s%n", discordLink));
        }
        this.getLogger().info(info.toString());
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        this.saveIpDataFile();
        this.getLogger().info("Wauf Plugin disabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("wauf")) {
            return false;
        }
        if (!sender.hasPermission(PERM_USE)) {
            sender.sendMessage("\u00a7cYou do not have permission to use this command.");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage("\u00a7eUsage: /wauf <player>");
            return true;
        }
        String targetName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        boolean excluded = false;
        excluded = target.isOnline() ? target.getPlayer().hasPermission(PERM_EXCLUDE) : this.ipDataConfig.getBoolean(targetName + ".exclude", false);
        if (excluded) {
            sender.sendMessage("\u00a7cThis player has chosen not to reveal their location.");
            return true;
        }
        String ip = this.ipDataConfig.getString(targetName + ".ip", null);
        if (ip == null) {
            sender.sendMessage("\u00a7cNo IP is registered for " + targetName + ".");
            return true;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String response = this.fetchGeo(ip);
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                sender.sendMessage("\u00a76Location of \u00a7f" + targetName + "\u00a76:");
                sender.sendMessage(response);
            });
        });
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        String ip = player.getAddress().getAddress().getHostAddress();
        boolean wasExcluded = this.ipDataConfig.getBoolean(name + ".exclude", false);
        this.ipDataConfig.set(name + ".ip", (Object)ip);
        this.ipDataConfig.set(name + ".exclude", (Object)wasExcluded);
        this.saveIpDataFile();
        if (player.hasPermission(PERM_EXCLUDE)) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String geo = this.fetchGeo(ip);
            String header = "\u00a76Location of \u00a7f" + name + "\u00a76:";
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!p.hasPermission(PERM_NOTIFY)) continue;
                    p.sendMessage(header);
                    p.sendMessage(geo);
                }
            });
        });
    }

    private String fetchGeo(String ip) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            URL url = new URL("https://api.hackertarget.com/ipgeo/?q=" + ip);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                sb.append("\u00a77").append(line).append("\n");
            }
            reader.close();
            conn.disconnect();
        }
        catch (IOException e) {
            this.getLogger().warning("Error fetching location for IP " + ip + ": " + e.getMessage());
            sb.setLength(0);
            sb.append("\u00a7cCould not retrieve location.");
        }
        return sb.toString();
    }

    private void saveIpDataFile() {
        try {
            this.ipDataConfig.save(this.ipDataFile);
        }
        catch (IOException e) {
            this.getLogger().warning("Could not save ipdata.yml: " + e.getMessage());
        }
    }
}

