#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0).rrrr * vertexColor * ColorModulator;

    // MENU
    vec3 target = vec3(1.0); // #ffffff
    if (distance(color.rgb, target) < 0.001) {
        color = vec4(0.8, 0.8, 0.8, color.a); // #cccccc
    }

    if (abs(color.r - 0.988) < 0.001 &&
        abs(color.g - 0.988) < 0.001 &&
        abs(color.b - 0.988) < 0.001) {
        color = vec4(0.8, 0.8, 0.8, color.a);
    }

    // SCRITTE UI
    if (distance(color.rgb, vec3(0.2479)) < 0.001) { // #3F3F3F
        color = vec4(0.5647, 0.5647, 0.5647, color.a); // #909090
    }

    // OMBRE SCRITTE PRINCIPALI
    if (distance(color.rgb, vec3(0.2431)) < 0.01) { // #3E3E3E
        color = vec4(0.098, 0.098, 0.098, color.a); // #191919
    }

    // SCRITTE FARO
    if (distance(color.rgb, vec3(0.867)) < 0.01) { // #DDDDDD
        color = vec4(0.5647, 0.5647, 0.5647, color.a); // #909090
    }

    // RIMUOVI OMBRE SCRITTE
    if (distance(color.rgb, vec3(0.2157)) < 0.01 || // #373737
        distance(color.rgb, vec3(0.1529)) < 0.01 || // #272727
        distance(color.rgb, vec3(0.0627, 0.1216, 0.0157)) < 0.01 || // #101F04
        distance(color.rgb, vec3(0.1255, 0.2431, 0.0314)) < 0.01    // #203E08
    ) {discard;

    }

    if (color.a < 0.1) {
        discard;
    }

    fragColor = apply_fog(
        color,
        sphericalVertexDistance,
        cylindricalVertexDistance,
        FogEnvironmentalStart,
        FogEnvironmentalEnd,
        FogRenderDistanceStart,
        FogRenderDistanceEnd,
        FogColor
    );
}