/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot;

import com.dudko.blazinghot.neoforge.BlazingHotImpl;
import com.dudko.blazinghot.registry.BlazingBlockEntityTypes;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.dudko.blazinghot.registry.BlazingCreativeTabs;
import com.dudko.blazinghot.registry.BlazingEntities;
import com.dudko.blazinghot.registry.BlazingFluids;
import com.dudko.blazinghot.registry.BlazingItems;
import com.dudko.blazinghot.registry.BlazingMetals;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlazingHot {
    public static final String ID = "blazinghot";
    public static final String NAME = "Create: Blazing Hot";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Blazing Hot");
    private static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"blazinghot");

    public static LangBuilder lang() {
        return new LangBuilder(ID);
    }

    public static void init() {
        LOGGER.info("Create mod addon {} initializing!", (Object)NAME);
        BlazingHot.finalizeRegistrate();
        BlazingMetals.init();
        BlazingCreativeTabs.register();
        BlazingItems.register();
        BlazingBlockEntityTypes.register();
        BlazingBlocks.register();
        BlazingTags.register();
        BlazingFluids.register();
        BlazingEntities.register();
        BlazingRecipeTypes.register();
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void finalizeRegistrate() {
        BlazingHotImpl.finalizeRegistrate();
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        REGISTRATE.defaultCreativeTab((ResourceKey)null);
    }
}

