/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.compat.jei.category;

import com.dudko.blazinghot.compat.jei.BlazingJEIHelper;
import com.dudko.blazinghot.compat.jei.category.animations.AnimatedBlazeMixer;
import com.dudko.blazinghot.compat.jei.category.neoforge.BlazeMixingCategoryImpl;
import com.dudko.blazinghot.content.kinetics.blaze_mixer.recipe.BlazeMixingRecipe;
import com.dudko.blazinghot.data.lang.BlazingLang;
import com.dudko.blazinghot.gui.BlazingGuiTextures;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import dev.architectury.injectables.annotations.ExpectPlatform;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class BlazeMixingCategory
extends BasinCategory {
    private final AnimatedBlazeMixer mixer = new AnimatedBlazeMixer();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    MixingType type;

    public static BlazeMixingCategory standard(CreateRecipeCategory.Info<BasinRecipe> info) {
        return new BlazeMixingCategory(info, MixingType.MIXING);
    }

    public static BlazeMixingCategory autoShapeless(CreateRecipeCategory.Info<BasinRecipe> info) {
        return new BlazeMixingCategory(info, MixingType.AUTO_SHAPELESS);
    }

    public static BlazeMixingCategory autoBrewing(CreateRecipeCategory.Info<BasinRecipe> info) {
        return new BlazeMixingCategory(info, MixingType.AUTO_BREWING);
    }

    protected BlazeMixingCategory(CreateRecipeCategory.Info<BasinRecipe> info, MixingType type) {
        super(info, type != MixingType.AUTO_SHAPELESS);
        this.type = type;
    }

    protected static SizedFluidIngredient getFuelFromRecipe(MixingType type, BasinRecipe recipe) {
        if (type == MixingType.AUTO_SHAPELESS) {
            return SizedFluidIngredient.of(BlazingTags.Fluids.BLAZE_MIXER_FUEL.tag(), (int)((Integer)BlazingConfigs.server().recipes.blazeShapelessFuelUsage.get()));
        }
        if (recipe instanceof BlazeMixingRecipe) {
            BlazeMixingRecipe bmRecipe = (BlazeMixingRecipe)recipe;
            return bmRecipe.getMixerFuel();
        }
        assert (Minecraft.getInstance().level != null);
        int calculatedCost = (int)BlazeMixingRecipe.getFuelCost(recipe, (Level)Minecraft.getInstance().level);
        return calculatedCost > 0 ? SizedFluidIngredient.of(BlazingTags.Fluids.BLAZE_MIXER_FUEL.tag(), (int)calculatedCost) : new SizedFluidIngredient(FluidIngredient.empty(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean includeFuel(MixingType type, BasinRecipe recipe) {
        void var1_1;
        return BlazeMixingCategoryImpl.includeFuel(type, (BasinRecipe)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFluidResultsSize(BasinRecipe recipe) {
        return BlazeMixingCategoryImpl.getFluidResultsSize(recipe);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BasinRecipe recipe, IFocusGroup focuses) {
        super.setRecipe(builder, recipe, focuses);
        SizedFluidIngredient fuelFluid = BlazeMixingCategory.getFuelFromRecipe(this.type, recipe);
        int vRows = (1 + recipe.getFluidResults().size() + recipe.getRollableResults().size()) / 2;
        if (BlazeMixingCategory.includeFuel(this.type, recipe)) {
            BlazingJEIHelper.addFluidSlot(builder, RecipeIngredientRole.INPUT, 142, 11 - 19 * (vRows - 1), fuelFluid).addRichTooltipCallback((v, t) -> t.add((FormattedText)BlazingLang.BLAZE_MIXER_FUEL.get().withStyle(ChatFormatting.DARK_GREEN)));
        }
    }

    public void draw(BasinRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat;
        super.draw(recipe, iRecipeSlotsView, graphics, mouseX, mouseY);
        if (BlazeMixingCategory.includeFuel(this.type, recipe)) {
            int vRows = (1 + BlazeMixingCategory.getFluidResultsSize(recipe) + recipe.getRollableResults().size()) / 2;
            BlazingGuiTextures.JEI_SHORT_ARROW_LEFT.render(graphics, 124, 16 - 19 * (vRows - 1));
        }
        if ((requiredHeat = recipe.getRequiredHeat()) != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.mixer.draw(graphics, this.getBackground().getWidth() / 2 + 3, 34);
    }

    public static enum MixingType {
        MIXING,
        AUTO_SHAPELESS,
        AUTO_BREWING;

    }
}

