/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.config;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.config.neoforge.CStressImpl;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public abstract class CStress
extends ConfigBase {
    private static final int VERSION = 1;
    protected static final Object2DoubleMap<ResourceLocation> DEFAULT_IMPACTS = new Object2DoubleOpenHashMap();
    protected static final Object2DoubleMap<ResourceLocation> DEFAULT_CAPACITIES = new Object2DoubleOpenHashMap();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CStress create() {
        return CStressImpl.create();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setNoImpact() {
        return CStress.setImpact(0.0);
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setImpact(double value) {
        return builder -> {
            CStress.assertFromBlazinghot(builder);
            ResourceLocation id = BlazingHot.asResource(builder.getName());
            DEFAULT_IMPACTS.put((Object)id, value);
            return builder;
        };
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> setCapacity(double value) {
        return builder -> {
            CStress.assertFromBlazinghot(builder);
            ResourceLocation id = BlazingHot.asResource(builder.getName());
            DEFAULT_CAPACITIES.put((Object)id, value);
            return builder;
        };
    }

    private static void assertFromBlazinghot(BlockBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("blazinghot")) {
            throw new IllegalStateException("Non-Blazing Hot blocks cannot be added to Blazing Hot's config.");
        }
    }

    public String getName() {
        return "stressValues.v1";
    }

    @Nullable
    public abstract DoubleSupplier getImpact(Block var1);

    @Nullable
    public abstract DoubleSupplier getCapacity(Block var1);

    protected static class Comments {
        public static String su = "[in Stress Units]";
        public static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        public static String capacity = "Configure how much stress a source can accommodate for.";

        protected Comments() {
        }
    }
}

