/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.config.neoforge;

import com.dudko.blazinghot.config.CStress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CStressImpl
extends CStress {
    protected final Map<ResourceLocation, ModConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Double>>();
    protected final Map<ResourceLocation, ModConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ModConfigSpec.ConfigValue<Double>>();

    public static CStress create() {
        return new CStressImpl();
    }

    public void registerAll(ModConfigSpec.Builder builder) {
        builder.comment(new String[]{".", CStress.Comments.su, CStress.Comments.impact}).push("impact");
        DEFAULT_IMPACTS.forEach((id, value) -> this.impacts.put((ResourceLocation)id, (ModConfigSpec.ConfigValue<Double>)builder.define(id.getPath(), value)));
        builder.pop();
        builder.comment(new String[]{".", CStress.Comments.su, CStress.Comments.capacity}).push("capacity");
        DEFAULT_CAPACITIES.forEach((id, value) -> this.capacities.put((ResourceLocation)id, (ModConfigSpec.ConfigValue<Double>)builder.define(id.getPath(), value)));
        builder.pop();
    }

    @Override
    @Nullable
    public DoubleSupplier getImpact(Block block) {
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        ModConfigSpec.ConfigValue<Double> value = this.impacts.get(id);
        return value == null ? null : () -> value.get();
    }

    @Override
    @Nullable
    public DoubleSupplier getCapacity(Block block) {
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)block);
        ModConfigSpec.ConfigValue<Double> value = this.capacities.get(id);
        return value == null ? null : () -> value.get();
    }
}

