/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.block.modern_lamp;

import com.dudko.blazinghot.content.block.modern_lamp.ModernLampBlockEntity;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.data.lang.BlazingLang;
import com.dudko.blazinghot.registry.BlazingBlockEntityTypes;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractModernLamp
extends Block
implements IBE<ModernLampBlockEntity> {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private final DyeColor color;

    public AbstractModernLamp(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{LIT}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        ModernLampBlockEntity be = (ModernLampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null && level.hasNeighborSignal(pos)) {
            be.powered = true;
            be.setChanged();
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean locked = this.isLocked(level, pos);
        if (!locked) {
            float pitch;
            float f = pitch = (Boolean)state.getValue((Property)LIT) != false ? 0.5f : 0.8f;
            if (!level.isClientSide) {
                BlazingAdvancements.MODERN_LAMP.awardTo(player);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
            level.playLocalSound(pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 1.0f, pitch, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean locked = this.isLocked(level, pos);
        if (stack.isEmpty() && !locked) {
            float pitch;
            float f = pitch = (Boolean)state.getValue((Property)LIT) != false ? 0.5f : 0.8f;
            if (!level.isClientSide) {
                BlazingAdvancements.MODERN_LAMP.awardTo(player);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LIT));
            level.playLocalSound(pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 1.0f, pitch, false);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.is(BlazingTags.Items.WRENCH.tag()) && !player.isCrouching()) {
            MutableComponent action = locked ? BlazingLang.LAMP_UNLOCKED_MESSAGE.get() : BlazingLang.LAMP_LOCKED_MESSAGE.get();
            player.displayClientMessage((Component)action, true);
            SoundEvent sound = locked ? SoundEvents.STONE_BUTTON_CLICK_ON : SoundEvents.STONE_BUTTON_CLICK_OFF;
            player.playSound(sound, 1.0f, 1.0f);
            this.setLocked(level, pos, !locked);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        boolean isPowered = this.isPowered(level, pos);
        if (isPowered == level.hasNeighborSignal(pos)) {
            return;
        }
        if (isPowered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            this.setPowered(level, pos, false);
            return;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        this.setPowered(level, pos, true);
        this.scheduleActivation(level, pos);
    }

    private void scheduleActivation(Level pLevel, BlockPos pPos) {
        if (!pLevel.getBlockTicks().hasScheduledTick(pPos, (Object)this)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isLocked(Level level, BlockPos pos) {
        ModernLampBlockEntity be = (ModernLampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        return be != null && be.locked;
    }

    public boolean isPowered(Level level, BlockPos pos) {
        ModernLampBlockEntity be = (ModernLampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        return be != null && be.powered;
    }

    public void setLocked(Level level, BlockPos pos, boolean locked) {
        ModernLampBlockEntity be = (ModernLampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.locked = locked;
            be.setChanged();
        }
    }

    public void setPowered(Level level, BlockPos pos, boolean powered) {
        ModernLampBlockEntity be = (ModernLampBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.powered = powered;
            be.setChanged();
        }
    }

    public Class<ModernLampBlockEntity> getBlockEntityClass() {
        return ModernLampBlockEntity.class;
    }

    public BlockEntityType<? extends ModernLampBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlazingBlockEntityTypes.MODERN_LAMP.get();
    }
}

