/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.block.modern_lamp;

import com.dudko.blazinghot.config.CClient;
import com.dudko.blazinghot.data.lang.BlazingLang;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModernLampBlockEntity
extends BlockEntity
implements IHaveGoggleInformation {
    public boolean powered;
    public boolean locked;

    public ModernLampBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putBoolean("powered", this.powered);
        tag.putBoolean("locked", this.locked);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.powered = tag.getBoolean("powered");
        this.locked = tag.getBoolean("locked");
        super.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithFullMetadata(registries);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (((CClient.ModernLampTooltip)((Object)BlazingConfigs.client().modernLampGoggleTooltip.get())).shouldRender(isPlayerSneaking)) {
            BlazingLang.LAMP_GOGGLE_TITLE.translate().forGoggles(tooltip);
            BlazingLang.LAMP_GOGGLE_STATE.translate().style(ChatFormatting.GRAY).forGoggles(tooltip);
            LangBuilder lockTranslation = this.locked ? BlazingLang.LAMP_GOGGLE_LOCKED.translate() : BlazingLang.LAMP_GOGGLE_UNLOCKED.translate();
            ChatFormatting lockStyle = this.locked ? ChatFormatting.RED : ChatFormatting.GREEN;
            lockTranslation.style(lockStyle).forGoggles(tooltip, 1);
        }
        return false;
    }
}

