/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.block.modern_lamp;

import com.dudko.blazinghot.content.block.modern_lamp.AbstractModernLampPanel;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampPanelBlock;
import com.dudko.blazinghot.content.block.shape.AbstractPoint;
import com.dudko.blazinghot.content.block.shape.DirectionOffsetPoint;
import com.dudko.blazinghot.content.block.shape.Shapes;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.dudko.blazinghot.util.DyeUtil;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ModernLampDoublePanelBlock
extends ModernLampPanelBlock {
    public static final BooleanProperty HORIZONTAL = BooleanProperty.create((String)"horizontal");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ModernLampDoublePanelBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{HORIZONTAL}));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean isHorizontal = (Boolean)state.getValue((Property)HORIZONTAL);
        VoxelShape panel = Shapes.halfDoublePanel(isHorizontal);
        double offsetX = isHorizontal ? 0.0 : 0.46875;
        double offsetZ = isHorizontal ? 0.46875 : 0.0;
        return Shapes.shape(0.0, 0.0, 0.0, 16.0, 1.0, 16.0).add(panel).add(panel.move(offsetX, 0.0, offsetZ)).forDirectional().get((Direction)state.getValue((Property)FACING));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec2 clickedPos = AbstractPoint.flatten3D(context.getClickLocation().subtract(context.getClickedPos().getCenter()), facing.getAxis());
        DirectionOffsetPoint.DirectionOffset offset = AbstractPoint.getNearest(DirectionOffsetPoint.fourPoints(), (Vec2)clickedPos).offset;
        return (BlockState)state.setValue((Property)HORIZONTAL, (Comparable)Boolean.valueOf(offset.horizontal));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IPlacementHelper helper;
        if (!player.isShiftKeyDown() && player.mayBuild() && (helper = PlacementHelpers.get((int)placementHelperId)).matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hit);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(state -> BlazingBlocks.MODERN_LAMP_DOUBLE_PANELS.contains(state.getBlock()), state -> {
                boolean horizontal = (Boolean)state.getValue((Property)HORIZONTAL);
                Direction facing = (Direction)state.getValue((Property)AbstractModernLampPanel.FACING);
                if (facing.getAxis().isVertical()) {
                    return horizontal ? Direction.Axis.X : Direction.Axis.Z;
                }
                return horizontal ? facing.getCounterClockWise().getAxis() : Direction.Axis.Y;
            }, (Property)AbstractModernLampPanel.FACING);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset placementOffset = super.getOffset(player, world, state, pos, ray);
            if (placementOffset.equals(PlacementOffset.fail())) {
                return placementOffset;
            }
            return placementOffset.withTransform(newState -> (BlockState)((BlockState)newState.setValue((Property)HORIZONTAL, (Comparable)((Boolean)state.getValue((Property)HORIZONTAL)))).setValue((Property)AbstractModernLampPanel.FACING, (Comparable)((Direction)state.getValue((Property)AbstractModernLampPanel.FACING))));
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> DyeUtil.isIn(BlazingBlocks.MODERN_LAMP_DOUBLE_PANELS, stack);
        }
    }
}

