/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.block.modern_lamp;

import com.dudko.blazinghot.content.block.modern_lamp.AbstractModernLampPanel;
import com.dudko.blazinghot.content.block.modern_lamp.ModernLampDoublePanelBlock;
import com.dudko.blazinghot.content.block.shape.Shapes;
import com.dudko.blazinghot.registry.BlazingBlocks;
import com.dudko.blazinghot.util.DyeUtil;
import com.simibubi.create.foundation.block.DyedBlockList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModernLampPanelBlock
extends AbstractModernLampPanel
implements SimpleWaterloggedBlock {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ModernLampPanelBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IPlacementHelper helper;
        if (!player.isShiftKeyDown() && player.mayBuild() && (helper = PlacementHelpers.get((int)placementHelperId)).matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hit);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.shape(0.0, 0.0, 0.0, 16.0, 1.0, 16.0).add(1.0, 0.0, 1.0, 15.0, 2.0, 15.0).forDirectional().get((Direction)pState.getValue((Property)FACING));
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> DyeUtil.isIn(BlazingBlocks.MODERN_LAMP_PANELS, stack) || DyeUtil.isIn(BlazingBlocks.MODERN_LAMP_QUAD_PANELS, stack);
        }

        public Predicate<BlockState> getStatePredicate() {
            List<DyedBlockList<ModernLampDoublePanelBlock>> panels = List.of(BlazingBlocks.MODERN_LAMP_PANELS, BlazingBlocks.MODERN_LAMP_QUAD_PANELS, BlazingBlocks.MODERN_LAMP_DOUBLE_PANELS);
            return state -> panels.stream().anyMatch(list -> list.contains(state.getBlock()));
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.getLocation(), (Direction.Axis)((Direction)state.getValue((Property)AbstractModernLampPanel.FACING)).getAxis(), dir -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative((Direction)directions.get(0)), s -> (BlockState)s.setValue((Property)AbstractModernLampPanel.FACING, (Comparable)((Direction)state.getValue((Property)AbstractModernLampPanel.FACING))));
        }
    }
}

