/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.block.shape;

import java.util.Collection;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractPoint {
    public final Vec2 position;

    public AbstractPoint(Vec2 position) {
        this.position = position;
    }

    public static <T extends AbstractPoint> T getNearest(Collection<T> points, Vec2 position) {
        AbstractPoint nearest = null;
        double nearestDistance = -1.0;
        for (AbstractPoint point : points) {
            double distance = Mth.sqrt((float)point.position.distanceToSqr(position));
            if (!(distance < nearestDistance) && nearestDistance != -1.0) continue;
            nearest = point;
            nearestDistance = distance;
        }
        return (T)nearest;
    }

    public static Vec2 flatten3D(Vec3 vec3, Direction.Axis ignoredAxis) {
        return switch (ignoredAxis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> new Vec2(AbstractPoint.f(vec3.z), AbstractPoint.f(vec3.y));
            case Direction.Axis.Y -> new Vec2(AbstractPoint.f(vec3.x), AbstractPoint.f(vec3.z));
            case Direction.Axis.Z -> new Vec2(AbstractPoint.f(vec3.x), AbstractPoint.f(vec3.y));
        };
    }

    protected static float f(double value) {
        return (float)value;
    }
}

