/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.block.shape;

import com.dudko.blazinghot.content.block.shape.AbstractPoint;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec2;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OffsetPoint
extends AbstractPoint {
    public final Offset offset;

    public OffsetPoint(Offset offset) {
        super(offset.getVector());
        this.offset = offset != Offset.RIGHT && offset != Offset.LEFT ? offset.getOpposite(Direction.Axis.X) : offset;
    }

    public static List<OffsetPoint> getPoints() {
        return Stream.of(Offset.values()).map(OffsetPoint::new).toList();
    }

    public static enum Offset implements StringRepresentable
    {
        UP_RIGHT("up_right", 0.5, -0.5),
        RIGHT("right", 0.5, 0.0),
        DOWN_RIGHT("down_right", 0.5, 0.5),
        DOWN_LEFT("down_left", -0.5, 0.5),
        LEFT("left", -0.5, 0.0),
        UP_LEFT("up_left", -0.5, -0.5),
        UP("up", 0.0, -0.5),
        DOWN("down", 0.0, 0.5),
        CENTER("center", 0.0, 0.0);

        private final String name;
        public final double x;
        public final double y;

        private Offset(String name, double x, double y) {
            this.name = name;
            this.x = x;
            this.y = y;
        }

        public Vec2 getVector() {
            return new Vec2(AbstractPoint.f(this.x), AbstractPoint.f(this.y));
        }

        public Vec2 getShapeOffsetVector() {
            return new Vec2(AbstractPoint.f(this.x + 0.5) / 2.0f, AbstractPoint.f(this.y + 0.5) / 2.0f);
        }

        public String getShortName() {
            String[] split = this.name.split("_");
            StringBuilder builder = new StringBuilder();
            for (String s : split) {
                builder.append(s.charAt(0));
            }
            return builder.toString();
        }

        public Offset getOpposite() {
            return this.getOpposite(Direction.Axis.X).getOpposite(Direction.Axis.Y);
        }

        public Offset getOpposite(Direction.Axis axis) {
            if (axis == Direction.Axis.X) {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> DOWN_RIGHT;
                    case 1 -> RIGHT;
                    case 2 -> UP_RIGHT;
                    case 3 -> UP_LEFT;
                    case 4 -> LEFT;
                    case 5 -> DOWN_LEFT;
                    case 6 -> DOWN;
                    case 7 -> UP;
                    case 8 -> CENTER;
                };
            }
            if (axis == Direction.Axis.Y) {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> UP_LEFT;
                    case 1 -> LEFT;
                    case 2 -> DOWN_LEFT;
                    case 3 -> DOWN_RIGHT;
                    case 4 -> RIGHT;
                    case 5 -> UP_RIGHT;
                    case 6 -> UP;
                    case 7 -> DOWN;
                    case 8 -> CENTER;
                };
            }
            return this;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

