/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.foundation.multiloader.BlazingBuilderTransformers;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.registry.BlazingCreativeTabs;
import com.dudko.blazinghot.registry.BlazingTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class Molds {
    public static List<Mold> ALL = new ArrayList<Mold>();
    private static final CreateRegistrate REGISTRATE = BlazingHot.registrate();
    public static final Mold BLANK;
    public static final Mold INGOT;
    public static final Mold NUGGET;
    public static final Mold SHEET;
    public static final Mold ROD;

    public static void register() {
    }

    static {
        BlazingCreativeTabs.useBaseTab();
        BLANK = new Mold("blank").register();
        INGOT = new Mold("ingot", MultiAmount.INGOT.get(), BlazingTags.Items.INGOTS.tag()).register();
        NUGGET = new Mold("nugget", MultiAmount.NUGGET.get(), BlazingTags.Items.NUGGETS.tag()).register();
        SHEET = new Mold("sheet", MultiAmount.INGOT.get(), BlazingTags.Items.PLATES.tag()).register();
        ROD = new Mold("rod", MultiAmount.ROD.get(), BlazingTags.Items.RODS.tag()).register();
    }

    public static class Mold {
        public final String name;
        public final long fluidAmount;
        public final TagKey<Item> shape;
        public final Map<MoldType, ItemEntry<? extends Item>> items = new HashMap<MoldType, ItemEntry<? extends Item>>();

        public Mold(String name) {
            this(name, 0L, null);
        }

        public Mold(String name, long fluidAmount, TagKey<Item> shape) {
            this.name = name;
            this.fluidAmount = fluidAmount;
            this.shape = shape;
        }

        private Mold register() {
            return this.register((AbstractRegistrate<?>)REGISTRATE);
        }

        public Mold register(AbstractRegistrate<?> registrate) {
            ALL.add(this);
            for (MoldType type : MoldType.values()) {
                this.items.put(type, (ItemEntry<? extends Item>)((ItemBuilder)registrate.item(type.name + "_" + this.name + "_mold", Item::new).transform(BlazingBuilderTransformers.mold(this.name, type))).recipe((c, p) -> {
                    if (type == MoldType.CLAY && this.shape != null) {
                        ItemEntry<? extends Item> blankMold = BLANK.get(MoldType.CLAY);
                        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{blankMold}), (RecipeCategory)RecipeCategory.MISC, this.get(type)).unlockedBy("has_" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)((Item)blankMold.get()))), RegistrateRecipeProvider.has(blankMold)).save((RecipeOutput)p, BlazingHot.asResource("stonecutting/clay_mold/" + this.name + "_from_blank"));
                    } else if (type == MoldType.PORCELAIN) {
                        ItemEntry<? extends Item> clayMold = this.get(MoldType.CLAY);
                        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{clayMold}), (RecipeCategory)RecipeCategory.MISC, this.get(type), (float)3.0f, (int)200).unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)clayMold.asItem()).getPath(), RegistrateRecipeProvider.has(clayMold)).save((RecipeOutput)p, String.valueOf(BlazingHot.asResource("smelting/porcelain_mold/")) + this.name + "_from_clay");
                    }
                }).register());
            }
            return this;
        }

        public ItemEntry<? extends Item> get(MoldType type) {
            return this.items.get((Object)type);
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MoldType {
        STURDY("sturdy", BlazingTags.Items.STURDY_MOLDS.tag(), true, true),
        CLAY("clay", BlazingTags.Items.CLAY_MOLDS.tag(), false, false, false),
        PORCELAIN("porcelain", BlazingTags.Items.PORCELAIN_MOLDS.tag(), false, false);

        public final String name;
        public final TagKey<Item> tag;
        public final boolean reusable;
        public final boolean fireResistant;
        public final boolean usable;

        private MoldType(String name, TagKey<Item> tag, boolean reusable, boolean fireResistant, boolean usable) {
            this.name = name;
            this.tag = tag;
            this.reusable = reusable;
            this.fireResistant = fireResistant;
            this.usable = usable;
        }

        private MoldType(String name, TagKey<Item> tag, boolean reusable, boolean fireResistant) {
            this(name, tag, reusable, fireResistant, true);
        }

        public String toString() {
            return this.name;
        }
    }
}

