/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBehaviourImpl;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CastingDepotBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<CastingDepotBehaviour> TYPE = new BehaviourType();
    public TransportedItemStackHandlerBehaviour transportedHandler;
    public Supplier<Integer> maxStackSize = () -> 1;
    public Supplier<Boolean> canAcceptItems = () -> !be.isPowered();
    public Predicate<Direction> canFunnelsPullFrom = $ -> true;
    public Consumer<ItemStack> onHeldInserted;
    public Predicate<ItemStack> acceptedItems = $ -> true;
    public boolean allowMerge;
    protected BehaviourType<CastingDepotBehaviour> behaviourType;
    @NotNull
    public ItemStack heldStack;
    protected List<TransportedItemStack> incoming;

    public CastingDepotBehaviour(CastingDepotBlockEntity be, BehaviourType<CastingDepotBehaviour> type) {
        super((SmartBlockEntity)be);
        this.onHeldInserted = $ -> {};
        this.behaviourType = type;
        this.allowMerge = false;
        this.heldStack = ItemStack.EMPTY;
        this.incoming = new ArrayList<TransportedItemStack>();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CastingDepotBehaviour of(CastingDepotBlockEntity be, BehaviourType<CastingDepotBehaviour> type) {
        void var1_1;
        return CastingDepotBehaviourImpl.of(be, (BehaviourType<CastingDepotBehaviour>)var1_1);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (!this.heldStack.isEmpty()) {
            compound.put("HeldStack", this.heldStack.saveOptional(registries));
        }
        if (this.canMergeItems() && !this.incoming.isEmpty()) {
            compound.put("Incoming", (Tag)NBTHelper.writeCompoundList(this.incoming, stack -> stack.serializeNBT(registries)));
        }
    }

    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.heldStack = ItemStack.EMPTY;
        if (compound.contains("HeldStack")) {
            this.heldStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("HeldStack"));
        }
        if (this.canMergeItems()) {
            ListTag list = compound.getList("Incoming", 10);
            this.incoming = NBTHelper.readCompoundList((ListTag)list, c -> TransportedItemStack.read((CompoundTag)c, (HolderLookup.Provider)registries));
        }
    }

    public abstract void addSubBehaviours(List<BlockEntityBehaviour> var1);

    public ItemStack getHeldItemStack() {
        return this.heldStack;
    }

    public boolean canMergeItems() {
        return this.allowMerge;
    }

    public abstract int getPresentStackSize();

    public abstract int getRemainingSpace();

    public abstract ItemStack insert(ItemStack var1, Direction var2, boolean var3);

    public abstract ItemStack extract(int var1, int var2, boolean var3);

    public void setHeldStack(ItemStack heldStack) {
        this.heldStack = heldStack;
    }

    public void removeHeldStack() {
        this.heldStack = ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        return this.heldStack.isEmpty() && this.isOutputEmpty();
    }

    protected abstract boolean isOccupied(Direction var1);

    public abstract boolean isOutputEmpty();

    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    protected abstract void handleBeltFunnelOutput();
}

