/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot;

import com.dudko.blazinghot.BlazingHot;
import com.dudko.blazinghot.config.CClient;
import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBehaviour;
import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlock;
import com.dudko.blazinghot.content.casting.casting_depot.SpoutCastingBehaviour;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBlockEntityImpl;
import com.dudko.blazinghot.data.advancement.BlazingAdvancement;
import com.dudko.blazinghot.data.advancement.BlazingAdvancements;
import com.dudko.blazinghot.data.lang.BlazingLang;
import com.dudko.blazinghot.foundation.mixin_interfaces.IAdvancementBehaviour;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.dudko.blazinghot.util.TooltipUtil;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public abstract class CastingDepotBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected SmartFluidTankBehaviour tank;
    public CastingDepotBehaviour depotBehaviour;
    protected SpoutCastingBehaviour castingBehaviour;
    protected FilteringBehaviour filtering;
    protected boolean contentsChanged;

    protected CastingDepotBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CastingDepotBlockEntity of(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        void var2_2;
        void var1_1;
        return CastingDepotBlockEntityImpl.of(type, (BlockPos)var1_1, (BlockState)var2_2);
    }

    public void sendData() {
        super.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.moldTooltip(tooltip, isPlayerSneaking);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.depotBehaviour = CastingDepotBehaviour.of(this, CastingDepotBehaviour.TYPE);
        behaviours.add(this.depotBehaviour);
        this.depotBehaviour.addSubBehaviours(behaviours);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new CastingDepotValueBox()).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.castingBehaviour = SpoutCastingBehaviour.of(this);
        behaviours.add(this.castingBehaviour);
        this.registerAwardables(behaviours, BlazingAdvancements.CASTING, BlazingAdvancements.STURDY_MOLD);
    }

    public SpoutCastingBehaviour.State getState() {
        return this.castingBehaviour.getState();
    }

    private boolean moldTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlazingLang.CASTING_GOGGLE_TITLE.translate().forGoggles(tooltip);
        if (this.getHeldItem().isEmpty()) {
            BlazingLang.CASTING_GOGGLE_NO_MOLD.translate().style(ChatFormatting.GRAY).forGoggles(tooltip);
        } else {
            MutableComponent name = this.getHeldItem().getHoverName().copy().withStyle(ChatFormatting.GRAY);
            BlazingHot.lang().add((Component)name).forGoggles(tooltip);
        }
        ChatFormatting coolingSpeedColor = ChatFormatting.AQUA;
        float coolingSpeed = (float)Math.round(this.getCoolingSpeed() * 100.0f) / 100.0f;
        if (coolingSpeed < 0.0f) {
            coolingSpeedColor = ChatFormatting.DARK_RED;
        } else if (coolingSpeed == 0.0f) {
            coolingSpeedColor = ChatFormatting.RED;
        } else if (coolingSpeed < 1.0f) {
            coolingSpeedColor = ChatFormatting.GOLD;
        } else if (coolingSpeed == 1.0f) {
            coolingSpeedColor = ChatFormatting.GREEN;
        }
        MutableComponent speedComponent = Component.literal((String)("x" + coolingSpeed)).withStyle(coolingSpeedColor);
        LangBuilder cooling = BlazingLang.CASTING_GOGGLE_COOLING_SPEED.translate().style(ChatFormatting.GRAY);
        cooling.add(Component.literal((String)" "));
        cooling.add(speedComponent);
        CClient.CastingProgressIndicator config = (CClient.CastingProgressIndicator)((Object)BlazingConfigs.client().castingProgressIndicator.get());
        switch (this.getState()) {
            case NONE: {
                ItemStack outputStack = this.getOutputItem();
                if (!outputStack.isEmpty()) {
                    LangBuilder output = BlazingHot.lang().text("\u2190 ").style(ChatFormatting.GREEN);
                    output.add(outputStack.getHoverName().copy().withStyle(ChatFormatting.GRAY));
                    output.forGoggles(tooltip);
                }
                cooling.forGoggles(tooltip);
                break;
            }
            case FILLING: {
                LangBuilder filling = BlazingHot.lang().text("\u2192 ").style(ChatFormatting.GOLD);
                filling.add(BlazingLang.fluidName(this.getVisualFluid()).style(ChatFormatting.GRAY));
                MutableComponent progress = CastingDepotBlockEntity.progressIndicator(config, 10, this.castingBehaviour.getProcessingTicks(), this.castingBehaviour.getRecipeProcessingDuration());
                if (config.inline) {
                    filling.add(Component.literal((String)" ")).add(progress);
                }
                filling.forGoggles(tooltip);
                if (!config.inline) {
                    BlazingHot.lang().add(progress).forGoggles(tooltip);
                }
                cooling.forGoggles(tooltip);
                break;
            }
            case COOLING: {
                Component castItem = this.castingBehaviour.castItem.getHoverName();
                LangBuilder filling = BlazingHot.lang().text("\u2744 ").style(ChatFormatting.AQUA).add(castItem.copy().withStyle(ChatFormatting.GRAY));
                MutableComponent progress = CastingDepotBlockEntity.progressIndicator(config, 10, this.castingBehaviour.getCoolingTicks(), this.castingBehaviour.coolingDuration);
                filling.forGoggles(tooltip);
                if (config == CClient.CastingProgressIndicator.NONE) {
                    cooling.forGoggles(tooltip);
                    break;
                }
                BlazingHot.lang().add(progress).add(Component.literal((String)" (").withStyle(ChatFormatting.GRAY).append((Component)speedComponent).append(")").withStyle(ChatFormatting.GRAY)).forGoggles(tooltip);
            }
        }
        return true;
    }

    public Fluid getVisualFluid() {
        return this.castingBehaviour.visualFluid;
    }

    public void setVisualFluid(Fluid visualFluid) {
        this.castingBehaviour.visualFluid = visualFluid;
    }

    public abstract ItemStack getHeldItem();

    public abstract ItemStack getOutputItem();

    public abstract void setOutputItem(ItemStack var1);

    public float getCoolingSpeed() {
        float min = BlazingConfigs.server().casting.minimumCoolingSpeed.getF();
        float max = BlazingConfigs.server().casting.maximumCoolingSpeed.getF();
        float modifier = 0.0f;
        for (FanProcessingType type : this.castingBehaviour.fanModifiers) {
            modifier += SpoutCastingBehaviour.getCoolingModifier(type);
        }
        return Mth.clamp((float)(1.0f + modifier), (float)min, (float)max);
    }

    public abstract void setFluid(Fluid var1, long var2);

    public abstract void resetFluid();

    public SmartFluidTankBehaviour getTank() {
        return this.tank;
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public boolean isPowered() {
        return (Boolean)this.getBlockState().getValue((Property)CastingDepotBlock.POWERED);
    }

    public void registerAwardables(List<BlockEntityBehaviour> behaviours, BlazingAdvancement ... advancements) {
        ((IAdvancementBehaviour)((Object)this)).blazinghot$registerAwardables(behaviours, advancements);
    }

    public void award(BlazingAdvancement advancement) {
        ((IAdvancementBehaviour)((Object)this)).blazinghot$award(advancement);
    }

    public void awardPlayerIfNear(BlazingAdvancement advancement, int maxDistance) {
        ((IAdvancementBehaviour)((Object)this)).blazinghot$award(advancement);
    }

    public static MutableComponent progressIndicator(CClient.CastingProgressIndicator config, int length, float value, float max) {
        float fill = value / max;
        ChatFormatting style = ChatFormatting.RED;
        if ((double)fill > 0.75) {
            style = ChatFormatting.GREEN;
        } else if ((double)fill > 0.5) {
            style = ChatFormatting.YELLOW;
        } else if ((double)fill > 0.25) {
            style = ChatFormatting.GOLD;
        }
        switch (config) {
            case BAR: {
                return TooltipUtil.asciiProgressBar(length, value, max);
            }
            case PERCENTAGE: {
                return Component.literal((String)(Math.round(fill * 100.0f) + "%")).withStyle(style);
            }
            case EXACT: {
                return Component.literal((String)(Math.round(value) + "/" + Math.round(max))).withStyle(style);
            }
        }
        return Component.empty();
    }

    static class CastingDepotValueBox
    extends ValueBoxTransform.Sided {
        CastingDepotValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)7.25, (double)15.5);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }
}

