/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotRendererImpl;
import com.dudko.blazinghot.util.DirectionUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CastingDepotRenderer
extends SmartBlockEntityRenderer<CastingDepotBlockEntity> {
    public CastingDepotRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CastingDepotBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        CastingDepotRenderer.renderFluid(be, partialTicks, ms, buffer, light);
        Direction direction = (Direction)be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        CastingDepotRenderer.renderItem(be.getLevel(), ms, buffer, light, overlay, be.getHeldItem(), direction, -0.045);
        CastingDepotRenderer.renderItem(be.getLevel(), ms, buffer, light, overlay, be.getOutputItem(), direction, -0.04);
    }

    public static void renderItem(Level level, PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack itemStack, Direction direction, double yOffset) {
        if (itemStack.isEmpty()) {
            return;
        }
        ms.pushPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        ms.translate(0.5, 0.75 + yOffset, 0.5);
        ms.scale(0.875f, 1.0f, 0.875f);
        if (!(itemStack.getItem() instanceof BlockItem)) {
            msr.rotateX((float)Math.toRadians(90.0));
        }
        msr.rotate(DirectionUtil.HORIZONTAL_ANGLES.get(direction).floatValue(), Direction.Axis.Z);
        itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, level, 0);
        ms.popPose();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderFluid(CastingDepotBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CastingDepotRendererImpl.renderFluid(be, (float)var1_1, (PoseStack)var2_2, (MultiBufferSource)var3_3, (int)var4_4);
    }

    public int getViewDistance() {
        return 32;
    }
}

