/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.SpoutCastingBehaviourImpl;
import com.dudko.blazinghot.registry.BlazingConfigs;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class SpoutCastingBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<SpoutCastingBehaviour> TYPE = new BehaviourType();
    protected State state = State.NONE;
    protected int processingTicks = -1;
    protected float coolingTicks = -1.0f;
    protected ItemStack castItem = ItemStack.EMPTY;
    protected boolean keepMold = false;
    protected int coolingDuration = -1;
    @NotNull
    protected Fluid visualFluid = Fluids.EMPTY;
    protected ResourceLocation currentRecipeId = null;
    public final List<FanProcessingType> fanModifiers = new ArrayList<FanProcessingType>();

    public SpoutCastingBehaviour(CastingDepotBlockEntity depot) {
        super((SmartBlockEntity)depot);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SpoutCastingBehaviour of(CastingDepotBlockEntity depot) {
        return SpoutCastingBehaviourImpl.of(depot);
    }

    @Nullable
    protected SpoutBlockEntity getSpout() {
        BlockEntity be = this.getWorld().getBlockEntity(this.getPos().above(2));
        if (be instanceof SpoutBlockEntity) {
            SpoutBlockEntity spout = (SpoutBlockEntity)be;
            return spout;
        }
        return null;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public State getState() {
        return this.state;
    }

    public int getProcessingTicks() {
        return this.processingTicks;
    }

    public float getCoolingTicks() {
        return this.coolingTicks;
    }

    public boolean canSpout() {
        return !((CastingDepotBlockEntity)this.blockEntity).isPowered();
    }

    public abstract int getRecipeCoolingDuration();

    public abstract int getRecipeProcessingDuration();

    public abstract void resetProcessing();

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        nbt.putFloat("CoolingTicks", this.coolingTicks);
        nbt.putInt("ProcessingTicks", this.processingTicks);
        nbt.putString("State", this.state.toString());
        nbt.putString("VisualFluid", BuiltInRegistries.FLUID.getKey((Object)this.visualFluid).toString());
        if (this.currentRecipeId != null) {
            nbt.putString("ProcessedRecipe", this.currentRecipeId.toString());
        }
        if (!this.castItem.isEmpty()) {
            CompoundTag castItemTag = new CompoundTag();
            nbt.put("CastItem", this.castItem.save(registries, (Tag)castItemTag));
        }
        nbt.putInt("CoolingDuration", this.coolingDuration);
        nbt.putBoolean("KeepMold", this.keepMold);
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        this.coolingTicks = nbt.getFloat("CoolingTicks");
        this.processingTicks = nbt.getInt("ProcessingTicks");
        this.state = State.valueOf(nbt.getString("State").toUpperCase());
        ResourceLocation fluidId = ResourceLocation.tryParse((String)nbt.getString("VisualFluid"));
        this.visualFluid = fluidId == null ? Fluids.EMPTY : (Fluid)BuiltInRegistries.FLUID.get(fluidId);
        if (nbt.contains("ProcessedRecipe")) {
            this.currentRecipeId = ResourceLocation.tryParse((String)nbt.getString("ProcessedRecipe"));
        }
        this.castItem = ItemStack.EMPTY;
        if (nbt.contains("CastItem")) {
            this.castItem = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("CastItem"));
        }
        this.coolingDuration = nbt.getInt("CoolingDuration");
        this.keepMold = nbt.getBoolean("KeepMold");
    }

    public static float getCoolingModifier(FanProcessingType type) {
        if (type.equals((Object)AllFanProcessingTypes.BLASTING)) {
            return BlazingConfigs.server().casting.blastingCoolingModifier.getF();
        }
        if (type.equals((Object)AllFanProcessingTypes.SPLASHING)) {
            return BlazingConfigs.server().casting.splashingCoolingModifier.getF();
        }
        return 0.0f;
    }

    public static enum State {
        NONE,
        FILLING,
        COOLING;

        public final boolean savable;

        private State(boolean savable) {
            this.savable = savable;
        }

        private State() {
            this.savable = true;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

