/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot.neoforge;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.recipe.CastingRecipe;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiFluidStack;
import com.dudko.blazinghot.foundation.multiloader.fluid.neoforge.MultiFluidStackNeoForge;
import com.dudko.blazinghot.registry.BlazingRecipeTypes;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class CastingBySpoutImpl {
    public static int getRequiredAmountForItem(Level world, ItemStack stack, MultiFluidStack availableFluid) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        for (RecipeHolder recipe : world.getRecipeManager().getRecipesFor(BlazingRecipeTypes.CASTING.getType(), (RecipeInput)input, world)) {
            CastingRecipe castingRecipe = (CastingRecipe)recipe.value();
            SizedFluidIngredient requiredFluid = castingRecipe.getRequiredFluid();
            if (!requiredFluid.test(MultiFluidStackNeoForge.toNeoForgeStack(availableFluid))) continue;
            return requiredFluid.amount();
        }
        return -1;
    }

    @Nullable
    public static RecipeHolder<CastingRecipe> findRecipe(CastingDepotBlockEntity depot, Level world, int requiredAmount, ItemStack stack, MultiFluidStack availableFluid) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        FluidStack toCast = MultiFluidStackNeoForge.toNeoForgeStack(availableFluid);
        toCast.setAmount(requiredAmount);
        RecipeHolder castingRecipe = null;
        for (RecipeHolder recipe : world.getRecipeManager().getRecipesFor(BlazingRecipeTypes.CASTING.getType(), (RecipeInput)input, world)) {
            RecipeHolder cr = recipe;
            SizedFluidIngredient requiredFluid = ((CastingRecipe)cr.value()).getRequiredFluid();
            if (!requiredFluid.test(toCast)) continue;
            castingRecipe = cr;
        }
        if (castingRecipe == null) {
            return null;
        }
        return CastingBySpoutImpl.matchFilter(depot, (CastingRecipe)castingRecipe.value()) ? castingRecipe : null;
    }

    public static boolean matchFilter(CastingDepotBlockEntity depot, CastingRecipe recipe) {
        FilteringBehaviour filter = depot.getFilter();
        if (filter == null || depot.getLevel() == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.getResultItem((HolderLookup.Provider)depot.getLevel().registryAccess()));
        if (recipe.getRollableResults().isEmpty() && !recipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)recipe.getFluidResults().getFirst());
        }
        return filterTest;
    }
}

