/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot.neoforge;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlockEntity;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBehaviourImpl;
import com.dudko.blazinghot.foundation.multiloader.fluid.MultiAmount;
import com.dudko.blazinghot.registry.BlazingBlockEntityTypes;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class CastingDepotBlockEntityImpl
extends CastingDepotBlockEntity {
    protected static int SPLASH_PARTICLE_COUNT = 1;

    protected CastingDepotBlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlazingBlockEntityTypes.CASTING_DEPOT.get(), (be, context) -> ((CastingDepotBehaviourImpl)be.depotBehaviour).itemHandler);
    }

    private CastingDepotBehaviourImpl castBehaviour() {
        return (CastingDepotBehaviourImpl)this.depotBehaviour;
    }

    @Override
    public ItemStack getHeldItem() {
        return this.depotBehaviour.heldStack;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.castBehaviour().processingOutputBuffer.getStackInSlot(0);
    }

    @Override
    public void setOutputItem(ItemStack stack) {
        this.castBehaviour().processingOutputBuffer.setStackInSlot(0, stack);
    }

    @Override
    public void setFluid(Fluid fluid, long amount) {
        this.tank.getPrimaryHandler().setFluid(new FluidStack(fluid, (int)amount));
    }

    public FluidStack getFluid() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @Override
    public void resetFluid() {
        this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((int)MultiAmount.BLOCK.multiply(4.0f).get())).forbidExtraction().forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    protected void spawnProcessingParticles(FluidStack fluid) {
        if (this.isVirtual()) {
            return;
        }
        if (fluid.isEmpty()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        vec = vec.add(0.0, 1.5, 0.0);
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        this.level.addAlwaysVisibleParticle(particle, vec.x, vec.y, vec.z, 0.0, (double)-0.1f, 0.0);
    }

    protected void spawnSplash(FluidStack fluid) {
        if (this.isVirtual()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        vec = vec.add(0.0, 0.3125, 0.0);
        ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
        for (int i = 0; i < SPLASH_PARTICLE_COUNT; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)this.level.random, (float)0.125f);
            m = new Vec3(m.x, Math.abs(m.y), m.z);
            this.level.addAlwaysVisibleParticle(particle, vec.x, vec.y, vec.z, m.x, m.y, m.z);
        }
    }

    protected void spawnCoolingParticles() {
        if (this.isVirtual()) {
            return;
        }
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        vec = vec.add(0.0, 0.3125, 0.0);
        for (int i = 0; i < 2; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)this.level.random, (float)0.02f);
            m = new Vec3(0.0, Math.abs(m.y), 0.0);
            this.level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, vec.x + (double)this.level.random.nextFloat() - 0.5, vec.y, vec.z + (double)this.level.random.nextFloat() - 0.5, m.x, m.y, m.z);
        }
    }

    public static CastingDepotBlockEntity of(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        return new CastingDepotBlockEntityImpl(type, pos, state);
    }
}

