/*
 * Decompiled with CFR 0.152.
 */
package com.dudko.blazinghot.content.casting.casting_depot.neoforge;

import com.dudko.blazinghot.content.casting.casting_depot.CastingDepotBlock;
import com.dudko.blazinghot.content.casting.casting_depot.SpoutCastingBehaviour;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBehaviourImpl;
import com.dudko.blazinghot.content.casting.casting_depot.neoforge.CastingDepotBlockEntityImpl;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CastingDepotItemHandler
implements IItemHandler {
    private static final int MAIN_SLOT = 0;
    private final CastingDepotBehaviourImpl behaviour;

    public CastingDepotItemHandler(CastingDepotBehaviourImpl behaviour) {
        this.behaviour = behaviour;
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.behaviour.getHeldItemStack() : this.behaviour.processingOutputBuffer.getStackInSlot(slot - 1);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        if (!this.behaviour.getHeldItemStack().isEmpty() && !this.behaviour.canMergeItems()) {
            return stack;
        }
        if (!this.behaviour.isOutputEmpty() && !this.behaviour.canMergeItems()) {
            return stack;
        }
        ItemStack remainder = this.behaviour.insert(stack, Direction.UP, simulate);
        if (!simulate && remainder != stack) {
            this.behaviour.blockEntity.notifyUpdate();
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            return this.behaviour.processingOutputBuffer.extractItem(slot - 1, amount, simulate);
        }
        CastingDepotBlockEntityImpl depot = (CastingDepotBlockEntityImpl)this.behaviour.blockEntity;
        if (!((Boolean)depot.getBlockState().getValue((Property)CastingDepotBlock.POWERED)).booleanValue()) {
            return ItemStack.EMPTY;
        }
        if (depot.getState() != SpoutCastingBehaviour.State.NONE || !depot.getOutputItem().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack held = this.behaviour.heldStack;
        if (held == ItemStack.EMPTY) {
            return held;
        }
        ItemStack stack = held.copy();
        ItemStack extracted = stack.split(amount);
        if (!simulate) {
            this.behaviour.heldStack = stack;
            this.behaviour.blockEntity.notifyUpdate();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return slot == 0 ? (Integer)this.behaviour.maxStackSize.get() : 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && this.behaviour.isItemValid(stack);
    }
}

